% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildglmmTMB}
\alias{buildglmmTMB}
\title{Use buildmer to perform stepwise elimination on glmmTMB models}
\usage{
buildglmmTMB(formula, data = NULL, family = "gaussian", cl = NULL,
  direction = c("order", "backward"), crit = "LRT", include = NULL,
  reduce.fixed = TRUE, reduce.random = TRUE, calc.summary = TRUE,
  quiet = FALSE, ...)
}
\arguments{
\item{formula}{The model formula for the maximal model you would like to fit, if possible.}

\item{data}{The data to fit the models to.}

\item{family}{The error distribution to use.}

\item{cl}{An optional cluster object as returned by function \code{makeCluster()} from package \code{parallel} to use for parallelizing the evaluation of terms.}

\item{direction}{Character string or vector indicating the direction for stepwise elimination; possible options are \code{'order'} (order terms by their contribution to the model), \code{'backward'} (backward elimination), \code{'forward'} (forward elimination, implies \code{order}). The default is the combination \code{c('order','backward')}, to first make sure that the model converges and to then perform backward elimination; other such combinations are perfectly allowed.}

\item{crit}{Character string or vector determining the criterion used to test terms for elimination. Possible options are \code{'LRT'} (likelihood-ratio test; this is the default), \code{'LL'} (use the raw -2 log likelihood), \code{'AIC'} (Akaike Information Criterion), and \code{'BIC'} (Bayesian Information Criterion).}

\item{include}{A character vector of terms that will be kept in the model at all times. These do not need to be specified separately in the \code{formula} argument.}

\item{reduce.fixed}{Logical indicating whether to reduce the fixed-effect structure.}

\item{reduce.random}{Logical indicating whether to reduce the random-effect structure.}

\item{calc.summary}{Logical indicating whether to also calculate the summary table for the final model after term elimination.}

\item{quiet}{Logical indicating whether to suppress progress messages.}

\item{...}{Additional options to be passed to \code{glmmTMB()}.}
}
\description{
Use buildmer to perform stepwise elimination on glmmTMB models
}
\examples{
library(buildmer)
m <- buildglmmTMB(Reaction ~ Days + (Days|Subject),lme4::sleepstudy)
\dontshow{\donttest{
# What's the point of both \dontshow and \donttest, you ask? I want this to be tested when checking my package with --run-donttest, but the model is statistically nonsensical, so no good in showing it to the user!
vowels$event <- with(vowels,interaction(participant,word))
m <- buildglmmTMB(f1 ~ timepoint,include=~ar1(0+participant|event),data=vowels)
}}
}
\seealso{
\code{\link[=buildmer]{buildmer()}}
}
