% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_feiertage.R
\name{feiertage_list}
\alias{feiertage_list}
\title{List German public holidays}
\usage{
feiertage_list(
  jahr = NULL,
  nur_land = NULL,
  nur_daten = NULL,
  safe = TRUE,
  refresh = FALSE
)
}
\arguments{
\item{jahr}{Year to query (defaults to current year on the API).}

\item{nur_land}{Optional Bundesland code to filter.}

\item{nur_daten}{Logical; return only date values (1) or include names (0).}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with holiday names and dates.

Region-level results include a \code{region} column and a \code{note} column for
holiday-specific hints.

Includes \code{date_time} as POSIXct in Europe/Berlin.
}
\description{
List German public holidays
}
\details{
The Feiertage API returns German public holidays from a Wikipedia-based
dataset. The endpoint supports filtering by year and Bundesland. Official
docs: https://github.com/bundesAPI/feiertage-api.
}
\examples{
\dontrun{
feiertage_list(jahr = 2024)
feiertage_list(jahr = 2024, nur_land = "BY")
}

}
\seealso{
\code{\link[=bunddev_parameters]{bunddev_parameters()}} for available query parameters.
}
