% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as.fhx}
\alias{as.fhx}
\title{Alias to \code{\link[=as_fhx]{as_fhx()}}}
\usage{
as.fhx(x)
}
\arguments{
\item{x}{A data frame or list-like object to cast. Must have named elements
for "year", "series", and "rec_type".}
}
\value{
\code{x} cast to an \code{fhx} object.
}
\description{
Alias to \code{\link[=as_fhx]{as_fhx()}}
}
\examples{
data(lgr2)
example_dataframe <- as.data.frame(lgr2)
back_to_fhx <- as_fhx(example_dataframe)

}
\seealso{
\itemize{
\item \code{\link[=fhx]{fhx()}} constructs an \code{fhx} object.
\item \code{\link[=is_fhx]{is_fhx()}} test whether object is \code{fhx}.
\item \code{\link[=make_rec_type]{make_rec_type()}} helpful to convert \code{rec_type}-like character vectors to
full facors with proper levels.
}
}
