% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvar-sv.R, R/print-bvharsp.R
\name{bvar_sv}
\alias{bvar_sv}
\alias{print.bvarsv}
\alias{knit_print.bvarsv}
\title{Fitting Bayesian VAR-SV}
\usage{
bvar_sv(
  y,
  p,
  num_chains = 1,
  num_iter = 1000,
  num_burn = floor(num_iter/2),
  thinning = 1,
  bayes_spec = set_bvar(),
  sv_spec = set_sv(),
  intercept = set_intercept(),
  include_mean = TRUE,
  minnesota = TRUE,
  save_init = FALSE,
  convergence = NULL,
  verbose = FALSE,
  num_thread = 1
)

\method{print}{bvarsv}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{knit_print}{bvarsv}(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{p}{VAR lag}

\item{num_chains}{Number of MCMC chains}

\item{num_iter}{MCMC iteration number}

\item{num_burn}{Number of burn-in (warm-up). Half of the iteration is the default choice.}

\item{thinning}{Thinning every thinning-th iteration}

\item{bayes_spec}{A BVAR model specification by \code{\link[=set_bvar]{set_bvar()}}, \code{\link[=set_ssvs]{set_ssvs()}}, or \code{\link[=set_horseshoe]{set_horseshoe()}}.}

\item{sv_spec}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} SV specification by \code{\link[=set_sv]{set_sv()}}.}

\item{intercept}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Prior for the constant term by \code{\link[=set_intercept]{set_intercept()}}.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{minnesota}{Apply cross-variable shrinkage structure (Minnesota-way). By default, \code{TRUE}.}

\item{save_init}{Save every record starting from the initial values (\code{TRUE}).
By default, exclude the initial values in the record (\code{FALSE}), even when \code{num_burn = 0} and \code{thinning = 1}.
If \code{num_burn > 0} or \code{thinning != 1}, this option is ignored.}

\item{convergence}{Convergence threshold for rhat < convergence. By default, \code{NULL} which means no warning.}

\item{verbose}{Print the progress bar in the console. By default, \code{FALSE}.}

\item{num_thread}{Number of threads}

\item{x}{\code{bvarsv} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{bvar_sv()} returns an object named \code{bvarsv} \link{class}.
\describe{
\item{coefficients}{Posterior mean of coefficients.}
\item{chol_posterior}{Posterior mean of contemporaneous effects.}
\item{param}{Every set of MCMC trace.}
\item{param_names}{Name of every parameter.}
\item{group}{Indicators for group.}
\item{num_group}{Number of groups.}
\item{df}{Numer of Coefficients: \verb{3m + 1} or \verb{3m}}
\item{p}{VAR lag}
\item{m}{Dimension of the data}
\item{obs}{Sample size used when training = \code{totobs} - \code{p}}
\item{totobs}{Total number of the observation}
\item{call}{Matched call}
\item{process}{Description of the model, e.g. \code{VHAR_SSVS_SV}, \code{VHAR_Horseshoe_SV}, or \code{VHAR_minnesota-part_SV}}
\item{type}{include constant term (\code{const}) or not (\code{none})}
\item{spec}{Coefficients prior specification}
\item{sv}{log volatility prior specification}
\item{intercept}{Intercept prior specification}
\item{init}{Initial values}
\item{chain}{The numer of chains}
\item{iter}{Total iterations}
\item{burn}{Burn-in}
\item{thin}{Thinning}
\item{y0}{\eqn{Y_0}}
\item{design}{\eqn{X_0}}
\item{y}{Raw input}
}
If it is SSVS or Horseshoe:
\describe{
\item{pip}{Posterior inclusion probabilities.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function fits VAR-SV.
It can have Minnesota, SSVS, and Horseshoe prior.
}
\details{
Cholesky stochastic volatility modeling for VAR based on
\deqn{\Sigma_t^{-1} = L^T D_t^{-1} L},
and implements corrected triangular algorithm for Gibbs sampler.
}
\references{
Carriero, A., Chan, J., Clark, T. E., & Marcellino, M. (2022). \emph{Corrigendum to “Large Bayesian vector autoregressions with stochastic volatility and non-conjugate priors” [J. Econometrics 212 (1)(2019) 137-154]}. Journal of Econometrics, 227(2), 506-512.

Chan, J., Koop, G., Poirier, D., & Tobias, J. (2019). \emph{Bayesian Econometric Methods (2nd ed., Econometric Exercises)}. Cambridge: Cambridge University Press.

Cogley, T., & Sargent, T. J. (2005). \emph{Drifts and volatilities: monetary policies and outcomes in the post WWII US}. Review of Economic Dynamics, 8(2), 262-302.

Gruber, L., & Kastner, G. (2022). \emph{Forecasting macroeconomic data with Bayesian VARs: Sparse or dense? It depends!} arXiv.
}
