% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_b0.R
\name{get_b0}
\alias{get_b0}
\title{Get Analytical Estimate for Utility Coefficient from Raw Counts}
\usage{
get_b0(total, best, worst)
}
\arguments{
\item{total}{The total number of times an item was showed to all
participants. That is, it is how many blocks an item appeared in times
how many participants saw those blocks}

\item{best}{The total number of times an item was selected as "best"}

\item{worst}{The number of times an item was selected as "worst"}
}
\value{
A named numeric vector of length 2, containing the utility
coefficient (b) and its associated standard error (se)
}
\description{
This function uses equations 7, 10, 12, and 13 from
Lipovetsky & Conklin (2014) to calculate utility coefficient for an item
based off of the analytical (i.e., closed-form) estimation of the
multinomial logit model.
}
\references{
Lipovetsky, S., & Conklin, M. (2014). Best-worst scaling in
analytical closed-form solution. The Journal of Choice Modelling, 10,
60-68. doi: 10.1016/j.jocm.2014.02.001
}
