% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_c14data.R
\name{get_c14data}
\alias{get_c14data}
\title{Download radiocarbon source databases and convert them to a \strong{c14_date_list}}
\usage{
get_c14data(databases = c())
}
\arguments{
\item{databases}{Character vector. Names of databases to be downloaded. "all" causes the download of all databases. \code{get_c14data()} prints a list of the currently available databases}
}
\description{
\code{get_c14data()} allows to download source databases and adjust their variables to conform to the
definition in the
\href{https://github.com/ropensci/c14bazAAR/blob/master/data-raw/variable_reference.csv}{variable_reference}
table. That includes renaming and arranging the variables (with \code{c14bazAAR::order_variables()})
as well as type conversion (with \code{c14bazAAR::enforce_types()}) -- so all the steps undertaken by
\code{as.c14_date_list()}. \cr
All databases require different downloading and data wrangling steps. Therefore
there's a custom getter function for each of them (see \code{?get_all_dates}). \cr

\code{get_c14data()} is a wrapper to download all dates from multiple databases and
\code{c14bazAAR::fuse()} the results.
}
\examples{

\dontrun{
 get_c14data(databases = c("adrac", "palmisano"))
  get_all_dates()}

}
