\name{expdata}
\alias{expdata}

\title{Example data set}
\usage{data( expdata )}
\arguments{
  \item{expdata}{Example data; rows correspond to variables (e.g. genes) and columns to samples.}
}
\value{
  \code{expdata} returns an example data set where rows are variables (e.g. genes) and columns are samples. It consists of 400 genes, 898 edges, and 800 steady-state samples. 
}
\description{
  \code{expdata} This data set has been generated by SynTRen. The source network corresponds to a subnetwork of E.coli (file name "EColi_full_HongWu_Ma_NAR2004.sif" from Ma HW, et. al. Nuc. Ac. Res. 2004). 
}
\details{
      The example is also given to provide a sample data set so that one can take it as reference while formatting the new data set as entry to c3net. Data sets must be complete and no empty or non-numerical character allowed.  
 }
\references{

	Ma HW, Kumar B, Ditges U, Gunzer F, Buer J, Zeng AP:  An extended transcriptional regulatory network of Escherichia coli and analysis of its hierarchical structure and network motifs. Nucleic Acids Res 2004 , 32:6643-6649

	Bulcke, T.V., Leemput, K.V., Naudts, B., et. al. (2006) Syntren: a generator of synthetic gene expression data for design and analysis of structure learning algorithms. BMC Bioinformatics, 7(1), 43.

      
	G. Altay, F. Emmert-Streib, "Inferring the conservative causal core of gene regulatory networks", BMC Systems Biology (2010) 4:132.    
}

\seealso{\code{\link{c3}}, \code{\link{c3net}}, \code{\link{makemim}} }

\examples{
data(expdata)
}
\keyword{misc}

