% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{derivationTable}
\alias{derivationTable}
\title{Create a table based on first order derivative of the regression model for specific age}
\usage{
derivationTable(A, model, minNorm = NULL, maxNorm = NULL, step = 0.1)
}
\arguments{
\item{A}{the age}

\item{model}{The regression model}

\item{minNorm}{The lower bound of the norm value range}

\item{maxNorm}{The upper bound of the norm value range}

\item{step}{Stepping parameter with lower values indicating higher precision}
}
\value{
data.frame with norm scores and the predicted scores based on the
derived regression function
}
\description{
In order to check model assumptions, a table of the first order derivative of the model
coefficients is created.
}
\examples{
normData <- prepareData()
m <- bestModel(data = normData)
d <- derivationTable(6, m, step = 0.5)
}
\seealso{
plotDerivative, derive
}
