% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators_weights.R
\name{calculateWeightsUnit}
\alias{calculateWeightsUnit}
\title{Calculate composite weights using unit weights}
\usage{
calculateWeightsUnit(
 .S                 = args_default()$.S,
 .csem_model        = args_default()$.csem_model,
 .starting_values   = args_default()$.starting_values
  )
}
\arguments{
\item{.S}{The (K x K) empirical indicator correlation matrix.}

\item{.csem_model}{A (possibly incomplete) \link{cSEMModel}-list.}

\item{.starting_values}{A named list of vectors where the
list names are the construct names whose indicator weights the user
wishes to set. The vectors must be named vectors of \code{"indicator_name" = value}
pairs, where \code{value} is the (scaled or unscaled) starting weight. Defaults to \code{NULL}.}
}
\value{
A named list. J stands for the number of constructs and K for the number
of indicators.
\describe{
\item{\verb{$W}}{A (J x K) matrix of estimated weights.}
\item{\verb{$E}}{\code{NULL}}
\item{\verb{$Modes}}{The mode used. Always "unit".}
\item{\verb{$Conv_status}}{\code{NULL} as there are no iterations}
\item{\verb{$Iterations}}{0 as there are no iterations}
}
}
\description{
Calculate unit weights for all blocks, i.e., each indicator of a block is
equally weighted.
}
