% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postestimate_verify.R
\name{verify}
\alias{verify}
\title{Verify admissibility}
\usage{
verify(.object)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}
}
\value{
A logical vector indicating which (if any) problem occurred.
A \code{FALSE} indicates that the specific problem has not occured. For models containg second-order
constructs estimated by a two stage approach, a list of two such vectors
(one for the first and one for the second stage) is returned. Status codes are:
\itemize{
\item 1: The algorithm has converged.
\item 2: All absolute standardized loading estimates are smaller than or equal to 1.
A violation implies either a negative variance of the measurement error or
\item 3: The construct VCV is positive semi-definite.
\item 4: All reliability estimates are smaller than or equal to 1.
\item 5: The model-implied indicator VCV is positive semi-definite.
This is only checked for linear models (including models containing
second-order constructs).
}
}
\description{
\lifecycle{stable}
}
\details{
Verify admissibility of the results obtained using \code{\link[=csem]{csem()}}.

Results exhibiting one of the following defects are deemed inadmissible:
non-convergence of the algorithm used to obtain weights, loadings and/or
(congeneric) reliabilities larger than 1, a construct variance-covariance (VCV) and/or
model-implied VCV matrix that is not positive semi-definite.

If \code{.object} is of class \code{cSEMResults_2ndorder} (i.e., estimates are
based on a model containing second-order constructs) both the first and the second stage are checked separately.

Currently, a model-implied indicator VCV matrix for nonlinear model is not
available. \code{verify()} therefore skips the check for positive definiteness of the
model-implied indicator VCV matrix for nonlinear models and returns "ok".
}
\examples{
### Without higher order constructs --------------------------------------------
model <- "
# Structural model
eta2 ~ eta1
eta3 ~ eta1 + eta2

# (Reflective) measurement model
eta1 =~ y11 + y12 + y13
eta2 =~ y21 + y22 + y23
eta3 =~ y31 + y32 + y33
"
  
# Estimate
out <- csem(threecommonfactors, model)
  
# Check admissibility
verify(out) # ok!

## Examine the structure of a cSEMVerify object
str(verify(out))

### With higher order constructs -----------------------------------------------
# If the model containes higher order constructs both the first and the second-
# stage estimates estimates are checked for admissibility

\dontrun{
require(cSEM.DGP) # download from https://m-e-rademaker.github.io/cSEM.DGP
  
# Create DGP with 2nd order construct. Loading for indicator y51 is set to 1.1
# to produce a failing first stage model
  
dgp_2ndorder <- "
## Path model / Regressions
eta2 ~ 0.5*eta1
eta3 ~ 0.35*eta1 + 0.4*eta2

## Composite model
eta1 =~ 0.8*y41 + 0.6*y42 + 0.6*y43
eta2 =~ 1.1*y51 + 0.7*y52 + 0.7*y53
c1   =~ 0.8*y11 + 0.4*y12
c2   =~ 0.5*y21 + 0.3*y22

## Higher order composite
eta3 =~ 0.4*c1 + 0.4*c2
"
  
dat <- generateData(dgp_2ndorder) # requires the cSEM.DGP package
out <- csem(dat, .model = dgp_2ndorder)

verify(out) # not ok
}
}
\seealso{
\code{\link[=csem]{csem()}}, \code{\link[=summarize]{summarize()}}, \link{cSEMResults}
}
