% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTMed-delta-med-std.R
\name{DeltaMedStd}
\alias{DeltaMedStd}
\title{Delta Method Sampling Variance-Covariance Matrix
for the Standardized Total, Direct, and Indirect Effects of X on Y
Through M
Over a Specific Time Interval
or a Range of Time Intervals}
\usage{
DeltaMedStd(
  phi,
  sigma,
  vcov_theta,
  delta_t,
  from,
  to,
  med,
  ncores = NULL,
  tol = 0.01
)
}
\arguments{
\item{phi}{Numeric matrix.
The drift matrix (\eqn{\boldsymbol{\Phi}}).
\code{phi} should have row and column names
pertaining to the variables in the system.}

\item{sigma}{Numeric matrix.
The process noise covariance matrix (\eqn{\boldsymbol{\Sigma}}).}

\item{vcov_theta}{Numeric matrix.
The sampling variance-covariance matrix of
\eqn{\mathrm{vec} \left( \boldsymbol{\Phi} \right)} and
\eqn{\mathrm{vech} \left( \boldsymbol{\Sigma} \right)}}

\item{delta_t}{Numeric.
Time interval
(\eqn{\Delta t}).}

\item{from}{Character string.
Name of the independent variable \eqn{X} in \code{phi}.}

\item{to}{Character string.
Name of the dependent variable \eqn{Y} in \code{phi}.}

\item{med}{Character vector.
Name/s of the mediator variable/s in \code{phi}.}

\item{ncores}{Positive integer.
Number of cores to use.
If \code{ncores = NULL},
use a single core.
Consider using multiple cores
when number of replications \code{R}
is a large value.}

\item{tol}{Numeric.
Smallest possible time interval to allow.}
}
\value{
Returns an object
of class \code{ctmeddelta} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{fun}{Function used ("DeltaMedStd").}
\item{output}{A list the length of which is equal to
the length of \code{delta_t}.}
}
Each element in the \code{output} list has the following elements:
\describe{
\item{delta_t}{Time interval.}
\item{jacobian}{Jacobian matrix.}
\item{est}{Estimated standardized total, direct, and indirect effects.}
\item{vcov}{Sampling variance-covariance matrix of the
estimated standardized total, direct, and indirect effects.}
}
}
\description{
This function computes the delta method
sampling variance-covariance matrix
for the standardized total, direct, and indirect effects
of the independent variable \eqn{X}
on the dependent variable \eqn{Y}
through mediator variables \eqn{\mathbf{m}}
over a specific time interval \eqn{\Delta t}
or a range of time intervals
using the first-order stochastic differential equation model's
drift matrix \eqn{\boldsymbol{\Phi}}
and process noise covariance matrix \eqn{\boldsymbol{\Sigma}}.
}
\details{
See \code{\link[=TotalStd]{TotalStd()}},
\code{\link[=DirectStd]{DirectStd()}}, and
\code{\link[=IndirectStd]{IndirectStd()}} for more details.
\subsection{Delta Method}{

Let \eqn{\boldsymbol{\theta}} be
a vector that combines
\eqn{\mathrm{vec} \left( \boldsymbol{\Phi} \right)},
that is,
the elements of the \eqn{\boldsymbol{\Phi}} matrix
in vector form sorted column-wise and
\eqn{\mathrm{vech} \left( \boldsymbol{\Sigma} \right)},
that is,
the unique elements of the \eqn{\boldsymbol{\Sigma}} matrix
in vector form sorted column-wise.
Let \eqn{\hat{\boldsymbol{\theta}}} be
a vector that combines
\eqn{\mathrm{vec} \left( \hat{\boldsymbol{\Phi}} \right)} and
\eqn{\mathrm{vech} \left( \hat{\boldsymbol{\Sigma}} \right)}.
By the multivariate central limit theory,
the function \eqn{\mathbf{g}}
using \eqn{\hat{\boldsymbol{\theta}}} as input
can be expressed as:

\deqn{
  	\sqrt{n}
  	\left(
  	\mathbf{g} \left( \hat{\boldsymbol{\theta}} \right)
  	-
  	\mathbf{g} \left( \boldsymbol{\theta} \right)
  	\right)
  	\xrightarrow[]{
  		\mathrm{D}
  	}
  	\mathcal{N}
  	\left(
  	0,
  	\mathbf{J}
  	\boldsymbol{\Gamma}
  	\mathbf{J}^{\prime}
  	\right)
  }

where \eqn{\mathbf{J}} is the matrix of first-order derivatives
of the function \eqn{\mathbf{g}}
with respect to the elements of \eqn{\boldsymbol{\theta}}
and
\eqn{\boldsymbol{\Gamma}}
is the asymptotic variance-covariance matrix of
\eqn{\hat{\boldsymbol{\theta}}}.

From the former,
we can derive the distribution of
\eqn{\mathbf{g} \left( \hat{\boldsymbol{\theta}} \right)} as follows:

\deqn{
  	\mathbf{g} \left( \hat{\boldsymbol{\theta}} \right)
  	\approx
  	\mathcal{N}
  	\left(
  	\mathbf{g} \left( \boldsymbol{\theta} \right)
  	,
  	n^{-1}
  	\mathbf{J}
  	\boldsymbol{\Gamma}
  	\mathbf{J}^{\prime}
  	\right)
  }

The uncertainty associated with the estimator
\eqn{\mathbf{g} \left( \hat{\boldsymbol{\theta}} \right)}
is, therefore, given by
\eqn{n^{-1} \mathbf{J} \boldsymbol{\Gamma} \mathbf{J}^{\prime}} .
When \eqn{\boldsymbol{\Gamma}} is unknown,
by substitution,
we can use
the estimated sampling variance-covariance matrix of
\eqn{\hat{\boldsymbol{\theta}}},
that is,
\eqn{\hat{\mathbb{V}} \left( \hat{\boldsymbol{\theta}} \right)}
for \eqn{n^{-1} \boldsymbol{\Gamma}}.
Therefore,
the sampling variance-covariance matrix of
\eqn{\mathbf{g} \left( \hat{\boldsymbol{\theta}} \right)}
is given by

\deqn{
  	\mathbf{g} \left( \hat{\boldsymbol{\theta}} \right)
  	\approx
  	\mathcal{N}
  	\left(
  	\mathbf{g} \left( \boldsymbol{\theta} \right)
  	,
  	\mathbf{J}
  	\hat{\mathbb{V}} \left( \hat{\boldsymbol{\theta}} \right)
  	\mathbf{J}^{\prime}
  	\right) .
  }
}
}
\examples{
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
colnames(phi) <- rownames(phi) <- c("x", "m", "y")
sigma <- matrix(
  data = c(
    0.24455556, 0.02201587, -0.05004762,
    0.02201587, 0.07067800, 0.01539456,
    -0.05004762, 0.01539456, 0.07553061
  ),
  nrow = 3
)
vcov_theta <- matrix(
  data = c(
    0.00843, 0.00040, -0.00151, -0.00600, -0.00033,
    0.00110, 0.00324, 0.00020, -0.00061, -0.00115,
    0.00011, 0.00015, 0.00001, -0.00002, -0.00001,
    0.00040, 0.00374, 0.00016, -0.00022, -0.00273,
    -0.00016, 0.00009, 0.00150, 0.00012, -0.00010,
    -0.00026, 0.00002, 0.00012, 0.00004, -0.00001,
    -0.00151, 0.00016, 0.00389, 0.00103, -0.00007,
    -0.00283, -0.00050, 0.00000, 0.00156, 0.00021,
    -0.00005, -0.00031, 0.00001, 0.00007, 0.00006,
    -0.00600, -0.00022, 0.00103, 0.00644, 0.00031,
    -0.00119, -0.00374, -0.00021, 0.00070, 0.00064,
    -0.00015, -0.00005, 0.00000, 0.00003, -0.00001,
    -0.00033, -0.00273, -0.00007, 0.00031, 0.00287,
    0.00013, -0.00014, -0.00170, -0.00012, 0.00006,
    0.00014, -0.00001, -0.00015, 0.00000, 0.00001,
    0.00110, -0.00016, -0.00283, -0.00119, 0.00013,
    0.00297, 0.00063, -0.00004, -0.00177, -0.00013,
    0.00005, 0.00017, -0.00002, -0.00008, 0.00001,
    0.00324, 0.00009, -0.00050, -0.00374, -0.00014,
    0.00063, 0.00495, 0.00024, -0.00093, -0.00020,
    0.00006, -0.00010, 0.00000, -0.00001, 0.00004,
    0.00020, 0.00150, 0.00000, -0.00021, -0.00170,
    -0.00004, 0.00024, 0.00214, 0.00012, -0.00002,
    -0.00004, 0.00000, 0.00006, -0.00005, -0.00001,
    -0.00061, 0.00012, 0.00156, 0.00070, -0.00012,
    -0.00177, -0.00093, 0.00012, 0.00223, 0.00004,
    -0.00002, -0.00003, 0.00001, 0.00003, -0.00013,
    -0.00115, -0.00010, 0.00021, 0.00064, 0.00006,
    -0.00013, -0.00020, -0.00002, 0.00004, 0.00057,
    0.00001, -0.00009, 0.00000, 0.00000, 0.00001,
    0.00011, -0.00026, -0.00005, -0.00015, 0.00014,
    0.00005, 0.00006, -0.00004, -0.00002, 0.00001,
    0.00012, 0.00001, 0.00000, -0.00002, 0.00000,
    0.00015, 0.00002, -0.00031, -0.00005, -0.00001,
    0.00017, -0.00010, 0.00000, -0.00003, -0.00009,
    0.00001, 0.00014, 0.00000, 0.00000, -0.00005,
    0.00001, 0.00012, 0.00001, 0.00000, -0.00015,
    -0.00002, 0.00000, 0.00006, 0.00001, 0.00000,
    0.00000, 0.00000, 0.00010, 0.00001, 0.00000,
    -0.00002, 0.00004, 0.00007, 0.00003, 0.00000,
    -0.00008, -0.00001, -0.00005, 0.00003, 0.00000,
    -0.00002, 0.00000, 0.00001, 0.00005, 0.00001,
    -0.00001, -0.00001, 0.00006, -0.00001, 0.00001,
    0.00001, 0.00004, -0.00001, -0.00013, 0.00001,
    0.00000, -0.00005, 0.00000, 0.00001, 0.00012
  ),
  nrow = 15
)

# Specific time interval ----------------------------------------------------
DeltaMedStd(
  phi = phi,
  sigma = sigma,
  vcov_theta = vcov_theta,
  delta_t = 1,
  from = "x",
  to = "y",
  med = "m"
)

# Range of time intervals ---------------------------------------------------
delta <- DeltaMedStd(
  phi = phi,
  sigma = sigma,
  vcov_theta = vcov_theta,
  delta_t = 1:5,
  from = "x",
  to = "y",
  med = "m"
)
plot(delta)

# Methods -------------------------------------------------------------------
# DeltaMedStd has a number of methods including
# print, summary, confint, and plot
print(delta)
summary(delta)
confint(delta, level = 0.95)
plot(delta)

}
\references{
Bollen, K. A. (1987).
Total, direct, and indirect effects in structural equation models.
Sociological Methodology, 17, 37.
\doi{10.2307/271028}

Deboeck, P. R., & Preacher, K. J. (2015).
No need to be discrete:
A method for continuous time mediation analysis.
Structural Equation Modeling: A Multidisciplinary Journal, 23 (1), 61–75.
\doi{10.1080/10705511.2014.973960}

Ryan, O., & Hamaker, E. L. (2021).
Time to intervene:
A continuous-time approach to network analysis and centrality.
Psychometrika, 87 (1), 214–252.
\doi{10.1007/s11336-021-09767-0}
}
\seealso{
Other Continuous Time Mediation Functions: 
\code{\link{BootBeta}()},
\code{\link{BootBetaStd}()},
\code{\link{BootIndirectCentral}()},
\code{\link{BootMed}()},
\code{\link{BootMedStd}()},
\code{\link{BootTotalCentral}()},
\code{\link{DeltaBeta}()},
\code{\link{DeltaBetaStd}()},
\code{\link{DeltaIndirectCentral}()},
\code{\link{DeltaMed}()},
\code{\link{DeltaTotalCentral}()},
\code{\link{Direct}()},
\code{\link{DirectStd}()},
\code{\link{ExpCov}()},
\code{\link{ExpMean}()},
\code{\link{Indirect}()},
\code{\link{IndirectCentral}()},
\code{\link{IndirectStd}()},
\code{\link{MCBeta}()},
\code{\link{MCBetaStd}()},
\code{\link{MCIndirectCentral}()},
\code{\link{MCMed}()},
\code{\link{MCMedStd}()},
\code{\link{MCPhi}()},
\code{\link{MCPhiSigma}()},
\code{\link{MCTotalCentral}()},
\code{\link{Med}()},
\code{\link{MedStd}()},
\code{\link{PosteriorBeta}()},
\code{\link{PosteriorIndirectCentral}()},
\code{\link{PosteriorMed}()},
\code{\link{PosteriorTotalCentral}()},
\code{\link{Total}()},
\code{\link{TotalCentral}()},
\code{\link{TotalStd}()},
\code{\link{Trajectory}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Continuous Time Mediation Functions}
\keyword{cTMed}
\keyword{delta}
\keyword{path}
