% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{getdoubled}
\alias{getdoubled}
\title{Converting a data matrix into a doubled matrix}
\usage{
getdoubled(Xinput, input = "nbyp", Jk = NULL, maxcat = NULL)
}
\arguments{
\item{Xinput}{A data matrix, in the form of a data frame or similar,
all variables must be ordered categorical with numerical categories}

\item{input}{See \code{\link{convert}}}

\item{Jk}{See \code{\link{convert}}}

\item{maxcat}{See \code{\link{convert}}}
}
\value{
A doubled matrix, where each variable is represented by 2 columns, and a data point
  taking the i-th category for a variable with J_k categories is given the values
  J_k-i in the first (low) column and i-1 in the second (high) column
}
\description{
\code{getdoubled} recodes a data matrix from one format (n objects by p variables,
counts for distinct combinations of p variables, contingency table) into a doubled matrix
}
\examples{
nishdoubled <- getdoubled(NishData)

}
\seealso{
Other conversion functions: 
\code{\link{convert}()},
\code{\link{getBurt}()},
\code{\link{getCT}()},
\code{\link{getindicator}()}
}
\concept{conversion functions}
