% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa_calendar.R, R/babylonian.R, R/bahai.R,
%   R/bali.R, R/chinese.R, R/coptic.R, R/egyptian.R, R/french.R,
%   R/gregorian.R, R/hebrew.R, R/icelandic.R, R/islamic.R, R/iso.R, R/julian.R,
%   R/lunar_calendars_astronomy.R, R/mayan.R, R/modern_hindu.R, R/old_hindu.R,
%   R/persian.R, R/roman.R, R/tibetan.R
\docType{data}
\name{new_calendar}
\alias{new_calendar}
\alias{cal_babylonian}
\alias{cal_bahai}
\alias{cal_balinese}
\alias{cal_chinese}
\alias{cal_japanese}
\alias{cal_korean}
\alias{cal_vietnamese}
\alias{cal_coptic}
\alias{cal_ethiopic}
\alias{cal_egyptian}
\alias{cal_armenian}
\alias{cal_french}
\alias{cal_afrench}
\alias{cal_gregorian}
\alias{cal_hebrew}
\alias{cal_icelandic}
\alias{cal_islamic}
\alias{cal_iso}
\alias{cal_julian}
\alias{cal_oislamic}
\alias{cal_saudi}
\alias{cal_ohebrew}
\alias{cal_samaritan}
\alias{cal_mayan}
\alias{cal_hindu_lunar}
\alias{cal_hindu_solar}
\alias{cal_old_hindu_solar}
\alias{cal_old_hindu_lunar}
\alias{cal_persian}
\alias{cal_apersian}
\alias{cal_roman}
\alias{cal_tibetan}
\title{Define calendar objects}
\usage{
new_calendar(
  name,
  short_name,
  granularities,
  validate_granularities,
  format,
  from_rd,
  to_rd
)

cal_babylonian

cal_bahai

cal_balinese

cal_chinese

cal_japanese

cal_korean

cal_vietnamese

cal_coptic

cal_ethiopic

cal_egyptian

cal_armenian

cal_french

cal_afrench

cal_gregorian

cal_hebrew

cal_icelandic

cal_islamic

cal_iso

cal_julian

cal_oislamic

cal_saudi

cal_ohebrew

cal_samaritan

cal_mayan

cal_hindu_lunar

cal_hindu_solar

cal_old_hindu_solar

cal_old_hindu_lunar

cal_persian

cal_apersian

cal_roman

cal_tibetan
}
\arguments{
\item{name}{Name of calendar}

\item{short_name}{Short name of calendar}

\item{granularities}{Character vector with names of granularities of calendar
(e.g., for the Gregorian calendar, the granularities are \code{year}, \code{month}, and \code{day}).}

\item{validate_granularities}{Function to check granularities are valid (e.g.,
Gregorian months should be between 1 and 12).}

\item{format}{Function to specify date format as a character string.}

\item{from_rd}{Function to convert from RD to calendar date.}

\item{to_rd}{Function to convert from calendar date to RD.}
}
\value{
A calendar object of class "calendar"
}
\description{
Generate a calendar object of class "calendar". Examples of calendars
produced in this way include \code{cal_chinese}, \code{cal_gregorian}, \code{cal_hebrew}, \code{cal_islamic},
and \code{cal_iso}.
}
\examples{
cal_gregorian
tibble::tibble(
  x = new_date(year = 2025, month = 5, day = 1:31, calendar = cal_gregorian),
  y = as_date(x, calendar = cal_islamic)
)
}
\keyword{datasets}
