% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{calc_weights}
\alias{calc_weights}
\title{Calculate inverse probability of censoring weights at time \code{t}.}
\usage{
calc_weights(
  data.mstate,
  data.raw,
  covs = NULL,
  t,
  s,
  landmark.type = "state",
  j = NULL,
  max.weight = 10,
  stabilised = FALSE,
  max.follow = NULL
)
}
\arguments{
\item{data.mstate}{Validation data in msdata format}

\item{data.raw}{Validation data in data.frame (one row per individual)}

\item{covs}{Character vector of variable names to adjust for when calculating inverse probability of censoring weights}

\item{t}{Follow up time at which to calculate weights}

\item{s}{Landmark time at which predictions were made}

\item{landmark.type}{Whether weights are estimated in all individuals uncensored at time s ('all') or only in individuals uncensored and in state j at time s ('state')}

\item{j}{Landmark state at which predictions were made (only required in landmark.type = 'state')}

\item{max.weight}{Maximum bound for weights}

\item{stabilised}{Indicates whether weights should be stabilised or not}

\item{max.follow}{Maximum follow up for model calculating inverse probability of censoring weights. Reducing this to \code{t} + 1 may aid in the proportional hazards assumption being met in this model.}
}
\value{
A dataframe with three columns. \code{id} corresponds to the patient ids from \code{data.raw}. \code{ipcw} contains the inverse probability
of censoring weights (specifically the inverse of the probability of being uncesored). \code{pcw = 1/ipcw}. If \code{stabilised = TRUE} was specified,
a fourth variable \code{ipcw.stab} will be returned, which is the stabilised inverse probability of censoring weights.
}
\description{
Estimates the inverse probability of censoring weights by fitting a cox-propotinal hazards model
in a landmark cohort of individuals. Primarily used internally, this function has
been exported to allow users to reproduce results in the vignette when
estimating confidence intervals using bootstrapping manually.
}
\details{
Estimates inverse probability of censoring weights (Hernan M, Robins J, 2020).
Fits a cox proportional hazards model to individuals in a landmark cohort, predicting the probability of being censored
at time \code{t}. This landmark cohort may either be all individuals uncensored at time \code{s}, or those uncensored
and in state \code{j} at time \code{s}. All predictors in \code{w.covs} are assumed to have a linear effect on the hazard.
Weights are estimated for all individuals in \code{data.raw}, even if they will not be used in the analysis as they do not meet the landmarking
requirements. If an individual enters an absorbing state prior to \code{t}, we estimate the probability of being censored
before the time of entry into the absorbing state, rather than at \code{t}. Details on all the above this are provided in
vignette \emph{overview}.
}
\examples{
# Estimate inverse probability of censoring weights for individual in cohort ebmtcal.
# Specifically the probability of being uncensored at t = 1826 days.
# Weights are estimated using a model fitted in all individuals uncensored at time s = 0.
weights.manual <-
calc_weights(data.mstate = msebmtcal,
  data.raw = ebmtcal,
  covs = c("year", "agecl", "proph", "match"),
  t = 1826,
  s = 0,
  landmark.type = "state",
  j = 1)

 str(weights.manual)

}
\references{
Hernan M, Robins J (2020). “12.2 Estimating IP weights via modeling.” In \emph{Causal Inference:
What If}, chapter 12.2. Chapman Hall/CRC, Boca Raton.
}
