% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calib_mlr.R
\name{calib_mlr}
\alias{calib_mlr}
\title{Create data for calibration curves using a multinomial logistic regression framework with inverse probability of censoring weights}
\usage{
calib_mlr(
  data.mstate,
  data.raw,
  j,
  s,
  t,
  tp.pred,
  smoother.type = "sm.ps",
  ps.int = 4,
  degree = 3,
  s.df = 4,
  niknots = 4,
  weights = NULL,
  w.function = NULL,
  w.covs = NULL,
  w.landmark.type = "state",
  w.max = 10,
  w.stabilised = FALSE,
  w.max.follow = NULL,
  ...
)
}
\arguments{
\item{data.mstate}{Validation data in \code{msdata} format}

\item{data.raw}{Validation data in \code{data.frame} (one row per individual)}

\item{j}{Landmark state at which predictions were made}

\item{s}{Landmark time at which predictions were made}

\item{t}{Follow up time at which calibration is to be assessed}

\item{tp.pred}{Vector of predicted transition probabilities at time t}

\item{smoother.type}{Type of smoothing applied. Takes values \code{s} (see \code{\link[VGAM]{s}}), \code{sm.ps} (see \code{\link[VGAM]{sm.ps}}) or \code{sm.os} (see \code{\link[VGAM]{sm.os}}).}

\item{ps.int}{the number of equally-spaced B spline intervals in the vector spline smoother (see \code{\link[VGAM]{sm.ps}})}

\item{degree}{the degree of B-spline basis in the vector spline smoother (see \code{\link[VGAM]{sm.ps}})}

\item{s.df}{degrees of freedom of vector spline (see \code{\link[VGAM]{s}})}

\item{niknots}{number of interior knots (see \code{\link[VGAM]{sm.os}})}

\item{weights}{Vector of inverse probability of censoring weights}

\item{w.function}{Custom function for estimating the inverse probability of censoring weights}

\item{w.covs}{Character vector of variable names to adjust for when calculating inverse probability of censoring weights}

\item{w.landmark.type}{Whether weights are estimated in all individuals uncensored at time s ('all') or only in individuals uncensored and in state j at time s ('state')}

\item{w.max}{Maximum bound for inverse probability of censoring weights}

\item{w.stabilised}{Indicates whether inverse probability of censoring weights should be stabilised or not}

\item{w.max.follow}{Maximum follow up for model calculating inverse probability of censoring weights. Reducing this to \code{t} + 1 may aid in the proportional hazards assumption being met in this model.}

\item{...}{Extra arguments to be passed to w.function (custom function for estimating weights)}
}
\value{
\code{\link{calib_mlr}} returns a list containing two elements:
\code{plotdata} and \code{metadata}. The \code{plotdata} element contains the
data for the calibration scatter plots This will itself be a list with each element
containing the data for the transition probabilities into each of the possible
states. Each list element contains patient ids (\code{id}), the predicted
transition probabilities (\code{pred}) and the estimated observed event
probabilities (\code{obs}). The \code{metadata} element contains metadata
including a vector of the possible transitions and other user specified information.
}
\description{
Creates the underlying data for the calibration plots. Observed event
probabilities at time \code{t} are estimated for inputted predicted
transition probabilities \code{tp.pred} out of state \code{j} at time \code{s}.
\code{calib_mlr} estimates calibration scatter plots using a multinomial logistic
framework in combination with landmarking and inverse probability of
censoring weights.

Two datasets for the same cohort of inidividuals must be provided. A \code{msdata}
format dataset generated using the \code{mstate} package. A \code{data.frame} with one
row per individual, relevant variables for estimating the weights, and a time
until censoring varaible (\code{dtcens}) and indicator (\code{dtcens.s}). Weights are
estimated using a cox-proportional hazard model and assuming linear
functional form of the variables defined in \code{w.covs}. We urge users to
specify their own modwl for estimating the weights. Confidence intervals for
the calibration scatter plots cannot be produced as it is currently unclear how
to present such data.
}
\details{
Observed event probabilities at time \code{t} are estimated for predicted
transition probabilities \code{tp.pred} out of state \code{j} at time \code{s}.
\code{calib_mlr} estimates calibration scatter plots uses a technique for assessing the calibration of multinomial logistic
regression models, namely the nominal calibration framework of van Hoorde et al. (2014, 2015).
Landmarking (van Houwelingen HC, 2007) is applied to only assess calibration in individuals who are uncensored
and in state \code{j} at time \code{s}. Censoring is dealt with using inverse probability of
censoring weights (Hernan M, Robins J, 2020).

Two datasets for the same cohort of inidividuals must be provided. Firstly \code{data.mstate} must be a dataset of class \code{msdata},
generated using the \code{[mstate]} package. This dataset is used to apply the landmarking. Secondly, \code{data.raw} must be
a \code{data.frame} with one row per individual, containing the desired variables for estimating the weights, and variables for the time
until censoring (\code{dtcens}), and an indicator for censoring \code{dtcens.s}, where (\code{dtcens.s = 1}) if
an individual is censored at time \code{dtcens}, and \code{dtcens.s = 0} otherwise. When an individual
enters an absorbing state, this prevents censoring from happening (i.e. dtcens.s = 0). Unless the user specifies
the weights using \code{weights}, the weights are
estimated using a cox-proportional hazard model, assuming a linear
functional form of the variables defined in \code{w.covs}. We urge users to
specify their own model for estimating the weights. The \code{weights} argument
must be a vector with length equal to the number of rows of \code{data.raw}.

Confidence intervals cannot be generated for the calibration scatter plots. While
confidence intervals could be estimated for each data point, it is not clear how
these would be plotted cohesively.

Calibration plots cannot be produced for specific transitions (i.e. \code{transitions.out}
in \code{\link{calib_blr}}) because the nominal calibration framework (van Hoorde et al., 2014, 2015) assesses
the calibration of all states simultaneously.

The calibration scatter plots can be plotted using \code{\link{plot.calib_mlr}}.
}
\examples{
# Using competing risks data out of initial state (see vignette: ... -in-competing-risk-setting).
# Estimate and plot MLR-IPCW calibration scatter plots for the predicted transition
# probabilities at time t = 1826, when predictions were made at time
# s = 0 in state j = 1. These predicted transition probabilities are stored in tp.cmprsk.j0.

# To minimise example time we reduce the datasets to 150 individuals.
# Extract the predicted transition probabilities out of state j = 1 for first 150 individuals
tp.pred <- tp.cmprsk.j0 |>
 dplyr::filter(id \%in\% 1:150) |>
 dplyr::select(any_of(paste("pstate", 1:6, sep = "")))
# Reduce ebmtcal to first 150 individuals
ebmtcal <- ebmtcal |> dplyr::filter(id \%in\% 1:150)
# Reduce msebmtcal.cmprsk to first 150 individuals
msebmtcal.cmprsk <- msebmtcal.cmprsk |> dplyr::filter(id \%in\% 1:150)

# Now estimate the observed event probabilities for each possible transition.
dat.calib.mlr <-
calib_mlr(data.mstate = msebmtcal.cmprsk,
 data.raw = ebmtcal,
 j=1,
 s=0,
 t = 1826,
 tp.pred = tp.pred,
 w.covs = c("year", "agecl", "proph", "match"),
 ps.int = 2,
 degree = 2)

# The data for each calibration scatter plots are stored in the "plotdata"
# list element.
str(dat.calib.mlr)

}
\references{
Hernan M, Robins J (2020). “12.2 Estimating IP weights via modeling.” In \emph{Causal Inference:
What If}, chapter 12.2. Chapman Hall/CRC, Boca Raton.

Van Hoorde K, Vergouwe Y, Timmerman D, Van Huffel S, Steyerberg W, Van Calster B
(2014). “Assessing calibration of multinomial risk prediction models.” \emph{Statistics in Medicine},
33(15), 2585–2596. doi:10.1002/sim.6114.

Van Hoorde K, Van Huffel S, Timmerman D, Bourne T, Van Calster B (2015).
“A spline-based tool to assess and visualize the calibration of multiclass risk predictions.”
\emph{Journal of Biomedical Informatics}, 54, 283–293. ISSN 15320464. doi:10.1016/j.jbi.2014.12.016.
URL http://dx.doi.org/10.1016/j.jbi.2014.12.016.

van Houwelingen HC (2007). “Dynamic Prediction by Landmarking in Event History Analysis.”
\emph{Scandinavian Journal of Statistics}, 34(1), 70–85.

Yee TW (2015). \emph{Vector Generalized Linear and Additive Models}. 1 edition.
Springer New, NY. ISBN 978-1-4939-4198-8. doi:10.1007/978-1-4939-2818-7.
URL https://link.springer.com/book/10.1007/978-1-4939-2818-7.
}
