% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpr_iter_sim.R
\name{cpr_iter_sim}
\alias{cpr_iter_sim}
\title{Simulate the number of iterations needed to generate a random community that
is sufficiently different from the original community}
\usage{
cpr_iter_sim(
  comm,
  null_model = "curveball",
  n_iterations = 100,
  thin = 1,
  seed = NULL
)
}
\arguments{
\item{comm}{Dataframe or matrix; input community data with
sites (communities) as rows and species as columns. Values of each cell are
the presence/absence (0 or 1) or number of individuals (abundance) of each
species in each site.}

\item{null_model}{Character vector of length 1 or object of class \code{commsim};
either the name of the model to use for generating random communities (null
model), or a custom null model. For full list of available predefined null
models, see the help file of \code{\link[vegan:commsim]{vegan::commsim()}}, or run
\code{\link[vegan:commsim]{vegan::make.commsim()}}. An object of class \code{commsim} can be generated with
\code{\link[vegan:commsim]{vegan::commsim()}}.}

\item{n_iterations}{Numeric vector of length 1; maximum number of iterations to
conduct.}

\item{thin}{Numeric vector of length 1; frequency to record percentage
similarity between original matrix and randomized matrix. Results will
be recorded every \code{thin} iterations (see Details).}

\item{seed}{Integer vector of length 1 or NULL; random seed that will be used
in a call to \code{set.seed()} before randomizing the matrix. Default (\code{NULL})
will not change the random generator state.}
}
\value{
Tibble (dataframe) with the following columns:
\itemize{
\item \code{iteration}: Number of iterations used to generate random community
\item \code{similarity}: Percentage similarity between original community and
random community
}
}
\description{
For randomization algorithms that involve swapping (iterations), there is no
way to know \emph{a-priori} how many iterations are needed to sufficiently "mix"
the community data matrix. \code{\link[=cpr_iter_sim]{cpr_iter_sim()}} records the percentage similarity
between the original matrix and a matrix that has been randomized with
successive swapping iterations, at each iteration.
}
\details{
The user should inspect the results to determine at what number of iterations
the original matrix and randomized matrix reach maximum dissimilarity (see
Examples). This number will strongly depend on the size and structure of the
original matrix. Large matrices with many zeros will likely take more
iterations, and even then still retain relatively high similarity between the
original matrix and the randomized matrix.

Available memory may be quickly exhausted if many (e.g., tens or hundreds of
thousands, or more) of iterations are used with no thinning on large
matrices; use \code{thin} to only record a portion of the results and save on
memory.

Of course, \code{\link[=cpr_iter_sim]{cpr_iter_sim()}} only makes sense for randomization algorithms
that use iterations.

Only presence/absence information is used to calculate percentage similarity
between community matrices.
}
\examples{
# Simulate generation of a random community with maximum of 10,000
# iterations, recording similarity every 100 iterations
(res <- cpr_iter_sim(
  comm = biod_example$comm,
  null_model = "swap",
  n_iterations = 10000,
  thin = 100,
  seed = 123
))

# Plot reveals that ca. 1000 iterations are sufficient to
# completely mix random community
plot(res$iteration, res$similarity, type = "l")

}
