% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_vectors.R
\name{get_cansim_vector}
\alias{get_cansim_vector}
\title{Retrieve data for a Statistics Canada data vector released within a given time frame}
\usage{
get_cansim_vector(
  vectors,
  start_time = as.Date("1800-01-01"),
  end_time = Sys.time(),
  use_ref_date = TRUE,
  refresh = FALSE,
  timeout = 200,
  factors = TRUE,
  default_month = "07",
  default_day = "01"
)
}
\arguments{
\item{vectors}{The list of vectors to retrieve}

\item{start_time}{Starting date in \code{YYYY-MM-DD} format, applies to \code{REF_DATE} or \code{releaseTime}, depending on \code{use_ref_date} parameter}

\item{end_time}{Set an optional end time filter in \code{YYYY-MM-DD} format (defaults to current system time)}

\item{use_ref_date}{Optional, \code{TRUE} by default. When set to \code{TRUE}, uses \code{REF_DATE} of vector data to filter, otherwise it uses StatisticsCanada's \code{releaseDate} value for filtering the specified vectors.}

\item{refresh}{(Optional) When set to \code{TRUE}, forces a reload of data table (default is \code{FALSE})}

\item{timeout}{(Optional) Timeout in seconds for downloading cansim table to work around scenarios where StatCan servers drop the network connection.}

\item{factors}{(Optional) Logical value indicating if dimensions should be converted to factors. (Default set to \code{TRUE}).}

\item{default_month}{The default month that should be used when creating Date objects for annual data (default set to "07")}

\item{default_day}{The default day of the month that should be used when creating Date objects for monthly data (default set to "01")}
}
\value{
A tibble with data for vectors released between start and end time
}
\description{
Retrieve data for a Statistics Canada data vector released within a given time frame
}
\examples{
\dontrun{
get_cansim_vector("v41690973","2015-01-01")
}
}
