\name{set.covar}
\alias{set.covar}
%- Also NEED an \alias for EACH other topic documented here.
\title{
Manually set which markers will be used as covariates.
}
\description{
This function takes in a vector of markers and flags them for use as covariates in the pairwise scan if \code{is.covar} is \code{TRUE}. If \code{is.covar} is \code{FALSE}, the specified markers flagged such that they are not used as covariates in the pairwise scan. This function can be useful if multiple markers in an LD block exceed the pairscan threshold and cannot be selected automatically. Using all markers in one block as covariates may not be desired as it will prevent any of the markers in the block from having significant direct influences on any of the phenotypes.
}
\usage{
set.covar(data.obj, markers, pheno = NULL, is.covar = TRUE, plot.covar = TRUE)
}
%- maybe also usage for other objects documented here.
\arguments{
  \item{data.obj}{
	The object in which all results are stored. See \code{\link{read.population}}.
	}
	\item{markers}{
		A vector specifying which markers are being specified as covariates or not covariates. The vector can specify the phenotypes either numerically or with characters, but the specification must be consistent for all entries.
	}
	\item{pheno}{
		A vector specifying which phenotype(s) should be considered. Markers are set to be used as covariates for each phenotype independently. The vector can specify the phenotypes either numerically or with characters, but the specification must be consistent for all entries. If set to NULL, the marker is assigned to be a covariate for all phenotypes.
		}
	\item{is.covar}{
		A logical value. If TRUE, the specified markers are flagged as covariates. If FALSE, the specified markers are flagged as non-covariates.
		}
	\item{plot.covar}{
		A logical value. If TRUE, the results of the covariate specification are plotted. This plot is identical to the plot generated by \code{\link{plotSinglescan}}. Markers that are spcified as covariates are colored red.
	}
}
\value{
This function operates on the element in data.obj called \code{covar.flags}. This element is a table with one row for each marker and one column for each trait being analyzed. The entry for each marker contains a 1 if it is to be used as a covariate and a 0 otherwise.
}
\references{
Carter, G. W., Hays, M., Sherman, A., & Galitski, T. (2012). Use of pleiotropy to model genetic interactions in a population. PLoS genetics, 8(10), e1003010. doi:10.1371/journal.pgen.1003010
}
\author{
Anna L. Tyler, Wei Lu, Justin J. Hendrick, Vivek M. Philip, and Gregory W. Carter
}

%% ~Make other sections like Warning with \section{Warning }{....} ~
\seealso{
\code{\link{plotSinglescan}}, \code{\link{get.covar}}, \code{\link{create.covar}}
}
\examples{
# not run
# obesity.cross <- set.covar(obesity.cross, pheno = "ET1", 
# markers = c("D1Mit213", "D1Mit76", "D1Mit46", "D1Mit200", "D1Mit37", "D2Mit2"), 
# is.covar = TRUE, plot.covar = TRUE)
}
% Add one or more standard keywords, see file KEYWORDS in the
% R documentation directory.
\keyword{arith}

