% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lin-alg.R
\name{symbol_is_matrix}
\alias{symbol_is_matrix}
\title{Check if object is a caracas matrix}
\usage{
symbol_is_matrix(x)
}
\arguments{
\item{x}{An object}
}
\description{
Check if object is a caracas matrix
}
\examples{

if (has_sympy() && sympy_version() >= "1.6") {
  x <- vector_sym(4)
  symbol_is_matrix(x)   ## TRUE
  x2 <- as.character(x) ## "Matrix([[v1], [v2], [v3], [v4]])"
  symbol_is_matrix(x2)  ## TRUE
  x3 <- as_character_matrix(x) ## R matrix
  symbol_is_matrix(x3)  ## FALSE 
}

}
\concept{linalg}
