% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circadian-patterns.R
\name{ggforest}
\alias{ggforest}
\title{Forest Plot of Hourly Odds}
\usage{
ggforest(ot, time = "time", or = "OR", lower = "Lower", upper = "Upper")
}
\arguments{
\item{ot}{Odd Ratio table with the following columns.}

\item{time}{Name of time variable (or "grouping" variable)}

\item{or}{Name of column containing odds ratio}

\item{lower}{Name of column of lower boundary of 95 percent CI}

\item{upper}{Name of column of upper boundary of 95 percent CI}
}
\value{
A ggplot of forest plot that can be extended. Default theme is
minimal and default color scheme is viridis.
}
\description{
Creates an OR plot for each hour of data given. Its a
ggplot format so additional variables, like titles, can be added in.
}
\details{
This function creates a forest plot using the OR developed
by the \link[card:circ_odds]{card::circ_odds} function in this package. By default, it
takes the output, which is a tibble named "ot",
and will generate a forest plot based on the grouping variable
(default is time of day). Original data can be restricted or the
hours can be reduced).
}
\examples{
# Data
data(twins)
ot <- circ_odds(twins, "hour", "sad_bin", "rDYX")

# Plot
library(ggplot2)
ggforest(ot) +
  labs(title = "Example") +
  scale_color_viridis_c(option = "A")

}
