% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recurrent-events.R
\name{recurrent_model_building}
\alias{recurrent_model_building}
\title{Recurrent Event Sequential Model Building}
\usage{
recurrent_model_building(data, covar.builds, model.type, prop.scores = NULL)
}
\arguments{
\item{data}{Data frame that is the survival format, potentially made by the
\link[card:recur_survival_table]{card::recur_survival_table}. Has to be merged with the superset of
covariates that are being tested.}

\item{covar.builds}{This is a vector that names the individual vectors for
each model, likely sequential and additive. The individual vectors contain
the names of the columns in the data frame that will generate regressions.}

\item{model.type}{Type of recurrent event data, selected from c("marginal",
"pwptt", "pwpgt")}

\item{prop.scores}{This is a vector of the names of which \code{covar.builds}
should be performed with propensity weighting. This will call a separate
function \link[card:recurrent_propensity]{card::recurrent_propensity} that will generate both a PROP_SCORE
column and PROP_WEIGHT column. Optional parameter, defaults to NULL.}
}
\value{
List of models in sequential order.
}
\description{
Takes a different covariate groups to generate several models
for recurrent event survival analyses.
}
\details{
Using the survival models in different types (e.g. marginal, PWP,
etc), to create Cox regressions that are in a sequential order. Using the
covariates given, will create the models on the fly. Need to specify model
type and provide data in a certain format.
}
