% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_kruskaltest.R
\name{ard_kruskaltest}
\alias{ard_kruskaltest}
\title{ARD Kruskal-Wallis Test}
\usage{
ard_kruskaltest(data, by, variable)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to compare by}

\item{variable}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to be compared}
}
\value{
ARD data frame
}
\description{
Analysis results data for Kruskal-Wallis Rank Sum Test.

Calculated with \code{kruskal.test(data[[variable]], data[[by]], ...)}
}
\examples{
cards::ADSL |>
  ard_kruskaltest(by = "ARM", variable = "AGE")
}
