% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_moodtest.R
\name{ard_moodtest}
\alias{ard_moodtest}
\title{ARD Mood Test}
\usage{
ard_moodtest(data, by, variable, ...)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame. See below for details.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to compare by.}

\item{variable}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to be compared.}

\item{...}{arguments passed to \code{mood.test(...)}}
}
\value{
ARD data frame
}
\description{
Analysis results data for Mood two sample test of scale. Note this not to be confused with
the Brown-Mood test of medians.
}
\details{
For the \code{ard_moodtest()} function, the data is expected to be one row per subject.
The data is passed as \code{mood.test(data[[variable]] ~ data[[by]], ...)}.
}
\examples{
cards::ADSL |>
  ard_moodtest(by = "SEX", variable = "AGE")
}
