% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_proportion_ci.R
\name{ard_proportion_ci}
\alias{ard_proportion_ci}
\title{ARD Proportion Confidence Intervals}
\usage{
ard_proportion_ci(
  data,
  variables,
  by = dplyr::group_vars(data),
  conf.level = 0.95,
  strata,
  weights = NULL,
  max.iterations = 10,
  method = c("waldcc", "wald", "clopper-pearson", "wilson", "wilsoncc", "strat_wilson",
    "strat_wilsoncc", "agresti-coull", "jeffreys")
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to include in summaries. Columns must be class \verb{<logical>}
or \verb{<numeric>} values coded as \code{c(0, 1)}.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to stratify calculations by}

\item{conf.level}{(\code{numeric})\cr
a scalar in \verb{(0, 1)} indicating the confidence level.
Default is \code{0.95}}

\item{strata, weights, max.iterations}{arguments passed to \code{proportion_ci_strat_wilson()},
when \code{method='strat_wilson'}}

\item{method}{(\code{string})\cr
string indicating the type of confidence interval to calculate.
Must be one of 'waldcc', 'wald', 'clopper-pearson', 'wilson', 'wilsoncc', 'strat_wilson', 'strat_wilsoncc', 'agresti-coull', 'jeffreys'.
See \code{?proportion_ci} for details.}
}
\value{
an ARD data frame
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
Calculate confidence intervals for proportions.
}
\examples{
ard_proportion_ci(mtcars, variables = c(vs, am), method = "wilson")
}
