% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_survey_svychisq.R
\name{ard_survey_svychisq}
\alias{ard_survey_svychisq}
\title{ARD Survey Chi-Square Test}
\usage{
ard_survey_svychisq(data, by, variables, statistic = "F", ...)
}
\arguments{
\item{data}{(\code{survey.design})\cr
a survey design object often created with the \{survey\} package}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to compare by.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column names to be compared. Independent tests will be computed for
each variable.}

\item{statistic}{(\code{character})\cr
statistic used to estimate Chisq p-value.
Default is the Rao-Scott second-order correction ("F"). See \code{\link[survey:svychisq]{survey::svychisq}}
for available statistics options.}

\item{...}{arguments passed to \code{\link[survey:svychisq]{survey::svychisq()}}.}
}
\value{
ARD data frame
}
\description{
Analysis results data for survey Chi-Square test using \code{\link[survey:svychisq]{survey::svychisq()}}.
Only two-way comparisons are supported.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = c("survey", "broom")))) withAutoprint(\{ # examplesIf}
data(api, package = "survey")
dclus1 <- survey::svydesign(id = ~dnum, weights = ~pw, data = apiclus1, fpc = ~fpc)

ard_survey_svychisq(dclus1, variables = sch.wide, by = comp.imp, statistic = "F")
\dontshow{\}) # examplesIf}
}
