#' @title MOBPRO: professional commuting flows in 2015
#' @name flows
#' @source \url{https://www.insee.fr/fr/statistiques/fichier/3566008/rp2015_mobpro_txt.zip}
#' @description
#' Statistical dataset in .csv:
#' \code{Extraction of the french national census : "Mobilités professionnelles en 2015 : déplacements domicile - lieu de travail"
#' - Base flux de mobilité - for the Greater Paris area.}\cr
#' \code{Citation: INSEE - RP MOBPRO, 2015.}\cr
#' \code{Variable (i) is the place of origin of the flow.}\cr
#' \code{Variable (j) is the place of destination of the flow.}\cr
#' \code{Variable (Fij) is the flow value for an (i,j) couple of origin-destination places.}\cr
#' \code{Variable (count) is the frequency of the (i,j) couple of places.}\cr
#' @docType data
NULL

#' @title Geographical ID
#' @name geoid
#' @description
#' \code{One column dataframe in.csv.}\cr
#' \code{Variable (COD_GEO_EPT) is the geographical code of the territory}\cr
#' \code{citation : APUR, 2018}
#' @source \url{https://www.insee.fr/fr/statistiques/fichier/3566008/rp2015_mobpro_txt.zip}
#' @docType data
NULL

#' @title Example of a small flow data matrix
#' @name mat_ex
#' @description Example of a small data, in format matrice
#' @docType data
NULL
