% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartographer-global.R
\name{register_map}
\alias{register_map}
\title{Register a new feature type}
\usage{
register_map(
  feature_type,
  data,
  feature_column,
  aliases = NULL,
  outline = NULL,
  lazy = TRUE
)
}
\arguments{
\item{feature_type}{Name of the type. If registering from within a package,
the suggested format is \code{"<package name>.<map name>"} to avoid clashes
between packages.}

\item{data}{A simple feature data frame with the map data, or a function
that returns a data frame. When \code{lazy} is \code{TRUE}, the value
will not be evaluated until the data is first accessed.}

\item{feature_column}{Name of the column of \code{data} that contains the
feature names.}

\item{aliases}{Optional named character vector or list that maps aliases to
values that appear in the feature column. This allows abbreviations or
alternative names to be supported.}

\item{outline}{Optional sf geometry containing just the outline of the map,
or a function returning such a geometry. When \code{lazy} is \code{TRUE},
the value will not be evaluated until the data is first accessed.}

\item{lazy}{When \code{TRUE}, defer evaluation of \code{data} and
\code{outline} until it is used.}
}
\value{
No return value; this updates the global feature registry.
}
\description{
This adds a new feature type that can then be used by all the geoms in this
package. If registering from another package, this should occur in the
\code{.onLoad()} hook in the package.
}
\details{
Registration supports delayed evaluation (lazy loading). This is particularly
useful for larger datasets, so that they are not loaded into memory until
they are accessed.
}
\examples{
 # register a map of the states of Italy from rnaturalearth using the
 # Italian names, and providing an outline of the country
 register_map(
   "italy",
   data = rnaturalearth::ne_states(country = "italy", returnclass = "sf"),
   feature_column = "name_it",
   outline = rnaturalearth::ne_countries(country = "italy", returnclass = "sf", scale = "large")
 )
}
\seealso{
\code{vignette("registering_maps")}
}
