% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartographr.R
\name{save_map}
\alias{save_map}
\title{Save a map to a file}
\usage{
save_map(plot, filename, device = "pdf")
}
\arguments{
\item{plot}{A ggplot object representing the map to be saved.}

\item{filename}{A character string specifying the path and name of the file to save the plot to.}

\item{device}{The output device defaulting to pdf}
}
\value{
The function saves the plot to a file and does not return anything.
}
\description{
This function saves a ggplot object to a file using the specified filename.
It checks for the orientation setting and warns if the scale factor has changed after the plot was created.
}
\examples{
\donttest{
data("osm")
my_map <- osm |> plot_map()
filename <- tempfile(fileext =  ".pdf")
save_map(my_map, filename)
unlink(filename)
}
}
