% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartographr.R
\name{crop}
\alias{crop}
\title{Crop a preprocessed map}
\usage{
crop(osm, boundary = "rect")
}
\arguments{
\item{osm}{A preprocessed OSM object to which the crop will be applied.}

\item{boundary}{The type of geometric boundary to apply to the OSM data.
Can be "rect" for a rectangular boundary, "circle" for a circular boundary,
"hex" for a hexagonal boundary, or an 'sf' object for a custom boundary.
Default is "rect".}
}
\value{
The OSM object with the specified geometric crop applied.
}
\description{
This function crops an OpenStreetMap (OSM) object that has been preprocessed.
It supports different types of geometric boundaries such as rectangles, circles, and hexagons,
or a custom boundary provided as an 'sf' object.
}
\details{
If the OSM object has not been preprocessed, the function will call \code{preprocess_map()}
to preprocess the data before applying the cropping. The type of preprocessing applied
is stored in the OSM object's metadata.
}
\examples{
\donttest{
data("osm")
# Apply a circular crop
osm_circle_cropped <- osm |> crop(boundary = "circle")
}
}
