% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBorders.R, R/getOuterBorders.R
\name{getBorders}
\alias{getBorders}
\alias{getOuterBorders}
\title{Extract Polygons Borders}
\usage{
getBorders(x, id, spdf, spdfid = NULL)

getOuterBorders(x, id, res = NULL, width = NULL, spdf, spdfid = NULL)
}
\arguments{
\item{x}{an sf object, a simple feature collection or a SpatialPolygonsDataFrame.}

\item{id}{name of the identifier variable in x, default to the first column. (optional)}

\item{spdf}{deprecated, a SpatialPolygonsDataFrame. This SpatialPolygonsDataFrame
has to be projected (planar coordinates).}

\item{spdfid}{deprecated, identifier field in spdf, default to the first column 
of the spdf data frame.  (optional)}

\item{res}{resolution of the grid used to compute outer borders (in x units).
A high resolution will give more detailed borders. (optional)}

\item{width}{maximum distance between used to compute outer borders (in x units).
A higher width will build borders between units that are farther apart. (optional)}
}
\value{
An sf object (MULTILINESTRING) of borders is returned. This object has three 
id variables: id, id1 and id2.
id1 and id2 are ids of units that neighbour a border; id is the concatenation 
of id1 and id2 (with "_" as separator).
}
\description{
Extract borders between polygons.

Outer borders are non-contiguous polygons borders (e.g.
maritime borders).
}
\note{
getBorders and getOuterBorders can be combined with rbind.
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
# Get borders
mtq.borders <- getBorders(x = mtq)
# Plot polygons
plot(st_geometry(mtq), border = NA, col = "grey60")
# Plot borders
plot(st_geometry(mtq.borders), 
     col = sample(x = rainbow(nrow(mtq.borders))), 
     lwd = 3, add = TRUE)
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
# Get units borders
mtq.outer <- getOuterBorders(x = mtq, res = 1000, width = 2500)
# Plot municipalities
plot(st_geometry(mtq), col = "grey60")
# Plot borders
plot(st_geometry(mtq.outer), col = sample(x = rainbow(nrow(mtq.outer))),
     lwd = 3, add = TRUE)
}
\seealso{
\link{discLayer}
}
