## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ---- message = F, comment = F, warning = F, eval=FALSE-----------------------
#  install.packages("cat.dt")

## -----------------------------------------------------------------------------
library(cat.dt)

## -----------------------------------------------------------------------------
data("itemBank")

## -----------------------------------------------------------------------------
TreeCAT = CAT_DT(bank = itemBank, model = "GRM", crit = "MEPV", C = 0.3, stop = 6, limit = 200, inters = 0.98, p = 0.9, dens = dnorm, 0, 1)

## -----------------------------------------------------------------------------
summary(TreeCAT)

## ---- fig.width = 7, fig.height = 4-------------------------------------------
plot_tree(TreeCAT, levels = 3, tree = 2)

## ---- echo = FALSE------------------------------------------------------------
set.seed(0)

## -----------------------------------------------------------------------------
individual_ev = predict(TreeCAT, itemRes[1, ])

## -----------------------------------------------------------------------------
individual_ev$estimation

## -----------------------------------------------------------------------------
individual_ev$llow
individual_ev$lupp

## -----------------------------------------------------------------------------
individual_ev$items

## ---- fig.width = 7-----------------------------------------------------------
individual_ev$graphics

## ---- eval = FALSE------------------------------------------------------------
#  individual_ev = TreeCAT$predict(itemRes[1, ])

## ---- eval = FALSE------------------------------------------------------------
#  individual_ev = CAT_ability_est(TreeCAT, itemRes[1, ])

## -----------------------------------------------------------------------------
group_ev = predict(TreeCAT, itemRes)

## -----------------------------------------------------------------------------
group_ev[[6]]$items

