% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_prob_array.R
\name{create_prob_array}
\alias{create_prob_array}
\title{Multidimensional array of response probabilities}
\usage{
create_prob_array(model, bank, nres)
}
\arguments{
\item{model}{polytomous IRT model. Options: \code{"GRM"} for Graded Response
Model and \code{"NRM"} for Nominal Response Model}

\item{bank}{matrix of the item bank. Rows represent items, and columns
represent parameters. If the model is \code{"GRM"}, the first column
represents the \code{alpha} parameters and the next columns represent the
\code{beta} parameters. If the model is \code{"NRM"}, odd columns represent
the \code{alpha} parameters and even columns represent \code{beta}
parameters}

\item{nres}{vector of number of possible responses for every item}
}
\value{
A 3-dimensional array of probability responses
}
\description{
For every item (dim 1) in an item bank and every evaluated ability level
(dim 2), computes the probability of picking every possible response (dim 3)
given the ability level
}
\author{
Javier Rodríguez-Cuadrado
}
