% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{selectItem}
\alias{selectItem}
\title{Select Next Item}
\usage{
selectItem(catObj)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}
}
\value{
The function \code{selectItem} returns a list with three elements:
 
\code{estimates}: a data frame with a row for each unasked question and three columns representing 
the item index number, the item name, and the item value (calculated by the specified selection method), 
and

\code{next_item}: a numeric representing the index of the item that should be asked next.

\code{next_item_name}: a string representing the unique identifier of the item that should be asked next.
}
\description{
Selects the next item in the question set to be administered to respondent based on the specified selection method.
}
\details{
Selection approach is specified in the \code{selection} slot of the \code{Cat} object.

The minimum expected posterior variance criterion is used when the \code{selection}
 slot is \code{"EPV"}.  This method calls \code{expectedPV} for each unasked item.

The maximum Fisher's information criterion is used when the \code{selection}
  slot is \code{"MFI"}.  This method calls \code{fisherInf} for each unasked item.
  
The maximum likelihood weighted information criterion is used when the \code{selection}
slot is \code{"MLWI"}. This method involves integration. See \strong{Note} for more information.

The maximum posterior weighted information criterion is used when the \code{selection}
slot is \code{"MPWI"}.  This method involves integration. See \strong{Note} for more information.
 
The maximum expected information criterion is used when the \code{selection}
slot is \code{"MEI"}.  This method calls \code{expectedObsInf} for each unasked item.

The maximum Kullback-Leibler information criterion is used when the \code{selection}
slot is \code{"KL"}.  This method calls \code{expectedKL} for each unasked item.

The maximum likelihood weighted Kullback-Leibler information criterion is used when the \code{selection}
slot is \code{"LKL"}.  This method calls \code{likelihoodKL} for each unasked item.

The maximum posterior weighted Kullback-Leibler information criterion is used when the \code{selection}
slot is \code{"PKL"}.  This method calls \code{posteriorKL} for each unasked item.

The maximum Fisher interval information criterion is used when the \code{selection}
slot is \code{"MFII"}. This method involves integration. See \strong{Note} for more information.
The bounds of integration are \eqn{\hat{\theta} \pm \delta},
 where \eqn{\delta} is \eqn{z} times the square root of the Fisher test information and
 \eqn{z} is specified in the \code{z} slot of the \code{Cat} object.

A random number generator is used when the \code{selection}
slot is \code{"RANDOM"}.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.

This function uses adaptive quadrature methods from the GNU Scientific
 Library (GSL) to approximate single-dimensional
 integrals with high accuracy.  The bounds of integration are determined by the
 \code{lowerBound} and \code{upperBound} slots of the \code{Cat} object unless otherwise noted.

The \code{"RANDOM"} item selection criterion uses the package \code{RcppArmadillo} to randomly
choose the next item among unasked questions.  \code{RcppArmadillo} provides an exact reproduction
of R's \code{sample} function that can be called from C++.

In the rare instance that item parameters are identical, it may be that that \code{selectItem} must choose
between two items with the same value calculated by the selection criterion.  In such an instance, \code{selectItem}
will choose the item with the lower question index.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Store example answers
setAnswers(ltm_cat) <- c(1,0,1,0,1, rep(NA, 35))

## Set different selection criterion and choose next item
setSelection(ltm_cat) <- "EPV"
selectItem(ltm_cat)

setSelection(ltm_cat) <- "MFI"
selectItem(ltm_cat)

setSelection(ltm_cat) <- "MLWI"
selectItem(ltm_cat)

setSelection(ltm_cat) <- "MPWI"
selectItem(ltm_cat)

setSelection(ltm_cat) <- "MEI"
selectItem(ltm_cat)

setSelection(ltm_cat) <- "KL"
selectItem(ltm_cat)

setSelection(ltm_cat) <- "LKL"
selectItem(ltm_cat)

setSelection(ltm_cat) <- "PKL"
selectItem(ltm_cat)

setSelection(ltm_cat) <- "MFII"
selectItem(ltm_cat)

setSelection(ltm_cat) <- "RANDOM"
selectItem(ltm_cat)


}
\references{
van der Linden, Wim J. 1998. "Bayesian Item Selection Criteria for Adaptive Testing." Psychometrika
63(2):201-216.

Van der Linden, Wim J., and Peter J. Pashley. 2009. "Item Selection and Ability
 Estimation in Adaptive Testing." Elements of Adaptive Testing. 
 Springer New York, 3-30.
 
 Veldkamp, B.P., 2003. Item Selection in Polytomous CAT.
  In New Developments in Psychometrics (pp. 207-214). Springer Japan.
}
\seealso{
\code{\link{estimateTheta}}, \code{\link{expectedPV}}, \code{\link{fisherInf}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
