% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{open_cat}
\alias{open_cat}
\title{Openness to Experience Cat Object}
\format{An object of class \code{Cat} of length 1.}
\source{
See \url{https://dataverse.harvard.edu/dataverse/pdsl} for the raw YouGov and/or Qualtrics data.
}
\usage{
data(open_cat)
}
\description{
Cat object containing item parameters for graded response model fit with responses to the 20-item Openness dimension of the 
100-item IPIP representation of Costa and McCrae's Five Factor Model
}
\details{
Cat object containing item parameters for graded response model fit with 774,410 response profiles by myPersonality Project and 1500 response profiles
collected by YouGov in June 2018.  The sample from myPersonality Project was a convenience sample, and the
respondents from YouGov were matched to a sampling frame on gender, age, race, and education.

See \code{\link{Cat-class}} for details regarding the Cat object structure.
See \code{\link{grmCat}} for details regarding the graded response model.

A normal prior was chosen with mean from the theta estimates from the YouGov sample (-.674) and a standard deviation (1.2)
wide enough to envelope the range of estimated theta values across both samples.

Note that due to how the item parameters were estimated, large, positive values indicate "more" of the latent trait.

Response options are 1=Very inaccurate; 2=Moderately inaccurate; 3=Neither inaccurate nor accurate;
4=Moderately accurate; 5=Very accurate.

The wording of the question items:

I...
\describe{
\item{\code{q91}}{Believe in the importance of art.}
\item{\code{q1}}{Have a vivid imagination.}
\item{\code{q51}}{Tend to vote for liberal political candidates.}
\item{\code{q41}}{Carry the conversation to a higher level.}
\item{\code{q61}}{Enjoy hearing new ideas.}
\item{\code{q31}}{Enjoy thinking about things.}
\item{\code{q21}}{Can say things beautifully.}
\item{\code{q16}}{Enjoy wild flights of fantasy.}
\item{\code{q81}}{Get excited by new ideas.}
\item{\code{q71}}{Have a rich vocabulary.}
\item{\code{q24}}{Am not interested in abstract ideas.}
\item{\code{q74}}{Do not like art.}
\item{\code{q7}}{Avoid philosophical discussions.}
\item{\code{q34}}{Do not enjoy going to art museums.}
\item{\code{q44}}{Tend to vote for conservative political candidates.}
\item{\code{q4}}{Do not like poetry.}
\item{\code{q94}}{Rarely look for a deeper meaning in things.}
\item{\code{q84}}{Believe that too much tax money goes to support artists.}
\item{\code{q54}}{Am not interested in theoretical discussions.}
\item{\code{q64}}{Have difficulty understanding abstract ideas.}
}
}
\references{
Costa, P. T., Jr., & McCrae, R. R. (1992). Revised NEO Personality Inventory (NEO PI-R)
and NEO Five-Factor Inventory (NEO-FFI): Professional manual. Odessa, FL: Psychological Assessment Resources.

Stillwell, David, and Michal Kosinski. 2007. "myPersonality Project."
\url{https://sites.google.com/michalkosinski.com/mypersonality}
}
\seealso{
\code{\link{Cat-class}}, \code{\link{grmCat}}
}
\keyword{datasets}
