% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{estimateSE}
\alias{estimateSE}
\title{Standard Error of Ability Parameter Estimate}
\usage{
estimateSE(catObj)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}
}
\value{
The function \code{estimateSE} returns a numeric for the standard error for \eqn{\theta}.
}
\description{
Estimates the standard error for a respondent's ability parameter estimate, \eqn{\theta}.
}
\details{
The function \code{estimateSE} estimates the standard error of the ability estimate
given the estimation approach of the \code{Cat} object, specified in \code{estimation} slot of \code{Cat} object.

The expected a posteriori approach is used when \code{estimation} slot is \code{"EAP"}.  This method involves integration. See \strong{Note} for more information.

The modal a posteriori approach is used when \code{estimation} slot is \code{"MAP"}.  This method is only available using the normal prior distribution.

The maximum likelihood approach is used when \code{estimation} slot is \code{"MLE"}.  When the likelihood
of the ability estimate is undefined,
the MAP or EAP method will be used, determined by what is specified in the \code{estimationDefault} slot in \code{Cat} object.

The weighted maximum likelihood approach is used when \code{estimation} slot is \code{"WLE"}.
Estimating \eqn{\theta} requires root finding with the ``Brent'' method in the GNU Scientific
 Library (GSL) with initial search interval of \code{[-5,5]}.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.

This function uses adaptive quadrature methods from the GNU Scientific
 Library (GSL) to approximate single-dimensional
 integrals with high accuracy.  The bounds of integration are determined by the
 \code{lowerBound} and \code{upperBound} slots of the \code{Cat} object.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Store example answers
setAnswers(ltm_cat) <- c(1,0,1,0,1, rep(NA, 35))

## Set different estimation procedures and calculate ability estimate and its standard error
setEstimation(ltm_cat) <- "EAP"
estimateTheta(ltm_cat)
estimateSE(ltm_cat)

setEstimation(ltm_cat) <- "MAP"
estimateTheta(ltm_cat)
estimateSE(ltm_cat)

setEstimation(ltm_cat) <- "MLE"
estimateTheta(ltm_cat)
estimateSE(ltm_cat)

setEstimation(ltm_cat) <- "WLE"
estimateTheta(ltm_cat)
estimateSE(ltm_cat)


}
\seealso{
\code{\link{estimateTheta}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
