% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bart_est.R
\name{bart_est}
\alias{bart_est}
\title{The BART estimator}
\usage{
bart_est(Y,
         treat,
         outcome_formula,
         data,
         grid_val,
         ...)
}
\arguments{
\item{Y}{is the the name of the outcome variable contained in \code{data}.}

\item{treat}{is the name of the treatment variable contained in
\code{data}.}

\item{outcome_formula}{is the formula used for fitting the outcome surface.
gps is one of the independent variables to use in the outcome_formula. ie.
\code{Y ~ treat + X.1 + X.2 + ...} or a variation of this.}

\item{data}{is a dataframe containing \code{Y}, \code{treat}, and
\code{X}.}

\item{grid_val}{contains the treatment values to be evaluated.}

\item{...}{additional arguments to be passed to the bart() outcome function.}
}
\value{
\code{bart_est} returns an object of class "causaldrf_simple",
a list that contains the following components:
\item{param}{parameter estimates for a bart fit.}
\item{out_mod}{the result of the bart fit.}
\item{call}{the matched call.}
}
\description{
This function estimates the ADRF using bart.
}
\details{
The mean DRF is estimated
}
\examples{
## Example from Schafer (2015).  bart takes a few minutes to run (depending on computer).

example_data <- sim_data

\dontrun{
# This estimate takes a long time to run...
bart_list <- bart_est(Y = Y,
          treat = T,
          outcome_formula = Y ~ T + B.1 + B.2 + B.3 + B.4 + B.5 + B.6 + B.7 + B.8,
          data = example_data,
          grid_val = seq(8, 16, by = 1))

sample_index <- sample(1:1000, 100)

plot(example_data$T[sample_index],
    example_data$Y[sample_index],
    xlab = "T",
    ylab = "Y",
    main = "bart estimate")

lines(seq(8, 16, by = 1),
      bart_list$param,
      lty = 2,
      lwd = 2,
      col = "blue")

legend('bottomright',
        "bart estimate",
        lty=2,
        lwd = 2,
        col = "blue",
        bty='Y',
        cex=1)
}

rm(example_data, bart_list, sample_index)
}
\references{
Schafer, J.L., Galagate, D.L. (2015).  Causal inference with a
continuous treatment and outcome: alternative estimators for parametric
dose-response models. \emph{Manuscript in preparation}.

Hill, Jennifer L. (2011). Bayesian nonparametric modeling for causal
inference. \emph{Journal of Computational and Graphical Statistics}
\bold{20.1} (2011).
}
\seealso{
\code{\link{nw_est}}, \code{\link{iw_est}}, \code{\link{hi_est}}, \code{\link{gam_est}},
\code{\link{add_spl_est}}, etc. for other estimates.

\code{\link{t_mod}}, \code{\link{overlap_fun}} to prepare the \code{data}
for use in the different estimates.
}

