% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfa.R
\name{lige}
\alias{lige}
\title{lige}
\usage{
lige(cfaobj, h, se = T)
}
\arguments{
\item{cfaobj}{a CFA object}

\item{h}{a bandwidth}

\item{se}{boolean whether or not to compute standard errors}
}
\value{
a CFASE object
}
\description{
compute the local intergenerational elasticity
}
\examples{
\dontrun{
data(igm)
tvals <- seq(10,12,length.out=8)
yvals <- seq(quantile(igm$lcfincome, .05), quantile(igm$lcfincome, .95), length.out=50)
## obtain counterfactual results
out <- cfa2(lcfincome ~ lfincome, tvals, yvals, igm, method1="qr",
xformla2=~HEDUC, method2="qr", iters=10, tau1=seq(.05,.95,.05),
tau2=seq(.05,.95,.05))
lige(out$cfa1, h=0.5)
}

}
