% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowsColumns.R, R/old_fns.R
\name{unpivot_to_blocks}
\alias{unpivot_to_blocks}
\alias{unpivotValuesToRows}
\title{Move values from columns to rows (anti-pivot, or "shred").}
\usage{
unpivot_to_blocks(data, nameForNewKeyColumn, nameForNewValueColumn,
  columnsToTakeFrom, ..., nameForNewClassColumn = NULL,
  env = parent.frame())

unpivotValuesToRows(data, nameForNewKeyColumn, nameForNewValueColumn,
  columnsToTakeFrom, ..., nameForNewClassColumn = NULL,
  env = parent.frame())
}
\arguments{
\item{data}{data.frame to work with (must be local, for remote please try \code{moveValuesToRows*}).}

\item{nameForNewKeyColumn}{character name of column to write new keys in.}

\item{nameForNewValueColumn}{character name of column to write new values in.}

\item{columnsToTakeFrom}{character array names of columns to take values from.}

\item{...}{force later argumets to bind by name.}

\item{nameForNewClassColumn}{optional name to land original cell classes to.}

\item{env}{environment to look for "winvector_temp_db_handle" in.}
}
\value{
new data.frame with values moved to rows.
}
\description{
For a tutorial please try \code{vignette('RowsAndColumns', package='cdata')}.

unpivotValuesToRows deprecated, functionality moved to: unpivot_to_blocks
}
\examples{

d <- data.frame(AUC= 0.6, R2= 0.2)
unpivot_to_blocks(d,
                 nameForNewKeyColumn= 'meas',
                 nameForNewValueColumn= 'val',
                 columnsToTakeFrom= c('AUC', 'R2'))

}
\seealso{
\code{\link{pivot_to_rowrecs}}
}
