% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_fields.R
\name{map_fields_q}
\alias{map_fields_q}
\title{Map field values from one column into new derived columns (query based, takes name of table).}
\usage{
map_fields_q(dname, cname, mname, my_db, rname)
}
\arguments{
\item{dname}{name of table to re-map.}

\item{cname}{name of column to re-map.}

\item{mname}{name of table of data describing the mapping (cname column is source, derived columns are destinations).}

\item{my_db}{DBI database handle.}

\item{rname}{name of result table.}
}
\value{
re-mapped table
}
\description{
Map field values from one column into new derived columns (query based, takes name of table).
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite(),
                        ":memory:")
DBI::dbWriteTable(
  my_db,
  'd',
  data.frame(what = c("acc", "loss",
                      "val_acc", "val_loss"),
             score = c(0.8, 1.2,
                       0.7, 1.7),
             stringsAsFactors = FALSE),
  overwrite = TRUE,
  temporary = TRUE)
DBI::dbWriteTable(
  my_db,
  'm',
  data.frame(what = c("acc", "loss",
                      "val_acc", "val_loss"),
             measure = c("accuracy", "log-loss",
                         "accuracy", "log-loss"),
             dataset = c("train", "train", "validation", "validation"),
             stringsAsFactors = FALSE),
  overwrite = TRUE,
  temporary = TRUE)

map_fields_q('d', 'what', 'm', my_db, "dm")
cdata::qlook(my_db, 'dm')
DBI::dbDisconnect(my_db)

}
