% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrFitted.R
\name{predict.cdfqr}
\alias{predict.cdfqr}
\alias{fitted.cdfqr}
\title{Methods for Cdfqr Objects}
\usage{
\method{predict}{cdfqr}(
  object,
  newdata = NULL,
  type = c("full", "mu", "sigma", "theta", "one", "zero"),
  quant = 0.5,
  ...
)

\method{fitted}{cdfqr}(
  object,
  type = c("full", "mu", "sigma", "theta", "one", "zero"),
  plot = FALSE,
  ...
)
}
\arguments{
\item{object}{A cdfqr model fit object}

\item{newdata}{Optional. A data frame in which to look for variables with which to predict. If not provided, the fitted values are returned}

\item{type}{A character that indicates whether the full model prediction/fitted values are needed, or values for the `mu` and `sigma` submodel only.}

\item{quant}{A number or a numeric vector (must be in (0, 1)) to specify the quantile(s) of the predicted value (when `newdata` is provided, and predicted values for responses are required). The default is to use median to predict response values.}

\item{...}{currently ignored}

\item{plot}{if a plot is needed.}
}
\description{
Methods for obtaining the fitted/predicted values for a fitted cdfqr object.
}
\examples{
data(cdfqrExampleData)
fit <- cdfquantreg(crc99 ~ vert | confl, 't2','t2', data = JurorData)

plot(predict(fit))
plot(predict(fit))
}
