% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_knn.R
\name{find_knn}
\alias{find_knn}
\title{Find approximate k-nearest neighbors}
\usage{
find_knn(featureMatrix, k = 50, n_trees = 50, seed = 42)
}
\arguments{
\item{featureMatrix}{Numeric matrix with features in rows, cells in columns.
Rows could be normalized genes or latent dimensions such as principal
components.}

\item{k}{Number of neighbors to find.}

\item{n_trees}{RccpAnnoy builds a forest  of \code{n_trees} trees.
More trees gives higher precision when querying. Default: 50.}

\item{seed}{Random seed for neighbor search, default: 42.}
}
\value{
List with two slots:
\itemize{
\item \code{idx} A NxK matrix (N cells, K neighbors) containing the integer
indexes of the approximate nearest neighbors in featureMatrix.
Each cell is considered to be its own nearest neighbor, next to
K-1 other neighbors.
\item \code{dist} A NxK matrix containing the distances of the nearest neighbors.
}
Inspired by \code{uwot::umap}'s return value when setting \code{ret_nn=TRUE}.
}
\description{
Implements RcppAnnoy's approximate nearest neighbor search
(much faster than precise neighbors).
Random search is made reproducible using \code{set.seed(seed)}.
Hint: If you pass \code{find_knn}'s output directly to \code{uwot::umap} via the
\code{nn_method} argument, make sure to set \code{umap}'s argument \code{n_sgd_threads}
to <=1 to ensure the UMAP embedding is reproducible.
}
\examples{
  # Imagine we have 30 cells and 100 features:
 fmat <- matrix(rnorm(3000), ncol=30)
 nn <- find_knn(fmat,k=15)
 # nn$idx has 30 rows and 15 columns.
}
