% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cell-rows-cell-cols.R
\name{cell_cols}
\alias{cell_cols}
\title{Specify cell limits only for columns}
\usage{
cell_cols(x)
}
\arguments{
\item{x}{vector of column limits; if character, converted to numeric; if
  length greater than two, min and max will be taken with \code{NA.rm = TRUE}}
}
\value{
a \code{cell_limits} object
}
\description{
How does this differ from \code{cell_limits}? Two ways. First, the input can
have length greater than 2, i.e. the columns can be specified as \code{1:n}.
If the length is greater than 2, both the min and max are taken with
\code{NA.rm = TRUE}. Note it is not possible to request non-contiguous
columns, i.e. columns 1, 2, and 5. In this case, the requested columns will
run from the minimum of 1 to the maximum of 5. Second, the input can be given
in the letter-based format spreadsheets use to label columns.
}
\examples{
cell_cols(c(NA, 3))
cell_cols(c(7, NA))
cell_cols(4:16)
cell_cols(c(3, NA, 10))

cell_cols("C:G")
cell_cols(c("B", NA))
cell_cols(LETTERS)
}

