% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cell-limits.R
\name{cell_limits}
\alias{as.cell_limits}
\alias{as.cell_limits.cell_limits}
\alias{as.cell_limits.character}
\alias{cell_limits}
\alias{dim.cell_limits}
\title{Create a cell_limits object}
\usage{
cell_limits(rows = c(NA_integer_, NA_integer_), cols = c(NA_integer_,
  NA_integer_))

\method{dim}{cell_limits}(x)

as.cell_limits(x)

\method{as.cell_limits}{cell_limits}(x)

\method{as.cell_limits}{character}(x)
}
\arguments{
\item{rows}{vector holding minimum and maximum row}

\item{cols}{vector holding minimum and maximum col}

\item{x}{input to convert into a \code{cell_limits} object}
}
\value{
a \code{cell_limits} object
}
\description{
The expectation is that \code{as.cell_limits} will be called to process
user-provided input on the target cell range for read/write operations on a
spreadsheet. Downstream code can be written assuming cell limits are stored
in a valid \code{cell_limits} object.
}
\details{
A \code{cell_limits} object is a list with two components:

\itemize{
\item \code{rows} vector, of the form \code{c(min, max)}
\item \code{cols} vector, of the form \code{c(min, max)}
}

Typically the \code{min} and \code{max} are positive integers, where the
first (the minimum) is less than or equal to the second (the maximum). A
value of \code{NA} means the corresponding limit is left unspecified.
Therefore a verbose way to specify no limits at all would be
\code{cell_limits(c(NA, NA), c(NA, NA))}.

Spreadsheet ranges can be specified using "A1" notation or "R1C1" notation
and dollar signs will be ignored, i.e. "A$1:$B$32" is equivalent to "A1:B32".
}
\examples{
cell_limits(c(1, 3), c(1, 5))
cell_limits(c(NA, 7), c(3, NA))
cell_limits(c(NA, 7))
cell_limits(cols = c(NA, 7))

dim(as.cell_limits("A1:F10"))
dim(cell_limits(cols = c(2, 5)))
as.cell_limits("A1")
as.cell_limits("Q24")
as.cell_limits("A1:D8")
as.cell_limits("R5C11")
as.cell_limits("R2C3:R6C9")
}

