% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportional_hazards-glmnet.R
\name{coxnet_train}
\alias{coxnet_train}
\title{Wrapper for glmnet for censored}
\usage{
coxnet_train(formula, data, alpha = 1, lambda = NULL, weights = NULL, ...)
}
\arguments{
\item{formula}{The model formula.}

\item{data}{The data.}

\item{alpha}{The elasticnet mixing parameter, with \eqn{0\le\alpha\le 1}.
The penalty is defined as
\deqn{(1-\alpha)/2||\beta||_2^2+\alpha||\beta||_1.} \code{alpha=1} is the
lasso penalty, and \code{alpha=0} the ridge penalty.}

\item{lambda}{A user supplied \code{lambda} sequence. Typical usage is to
have the program compute its own \code{lambda} sequence based on
\code{nlambda} and \code{lambda.min.ratio}. Supplying a value of
\code{lambda} overrides this. WARNING: use with care. Avoid supplying a
single value for \code{lambda} (for predictions after CV use
\code{predict()} instead).  Supply instead a decreasing sequence of
\code{lambda} values. \code{glmnet} relies on its warms starts for speed,
and its often faster to fit a whole path than compute a single fit.}

\item{weights}{observation weights. Can be total counts if responses are
proportion matrices. Default is 1 for each observation}

\item{...}{additional parameters passed to glmnet::glmnet.}
}
\value{
A fitted \code{glmnet} model.
}
\description{
Not to be used directly by users.
}
\details{
This wrapper translates from formula interface to glmnet's matrix due to how
stratification can be specified. glmnet requires that the \emph{response} is
stratified via \code{\link[glmnet:stratifySurv]{glmnet::stratifySurv()}}. censored allows specification via a
\code{\link[survival:strata]{survival::strata()}} term on the right-hand side of the formula. The formula
is used to generate the stratification information needed for stratifying the
response. The formula without the strata term is used for generating the
model matrix for glmnet.

The wrapper retains the original formula and the pre-processing elements
including the training data to allow for predictions from the fitted model.
}
\examples{
coxnet_mod <- coxnet_train(Surv(time, status) ~ age + sex, data = lung)
}
\keyword{internal}
