% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_c_closure.R
\name{calc_c_closure}
\alias{calc_c_closure}
\title{Calculate canopy closure date}
\usage{
calc_c_closure(param_rxt, x1 = 1.3, k = 6)
}
\arguments{
\item{param_rxt}{Output of the function \link{calc_r_x0}, which produces a
list containing parameters that are necessary to calculate \code{c_closure}.
These parameters are \code{r}, the growth rate, \code{x0}, the initial LAI
value, and \code{t0}, the initial date and the associated dates}

\item{x1}{LAI value at which 90\% canopy closure is reached. It is fixed to
1.3 for sugar beet.}

\item{k}{carrying capacity, which is the maximum LAI that can be attained.
This value can be cultivar-dependent. The default is fixed to 6}
}
\value{
\code{c_closure} date at which 90\% canopy closure is reached at each
location.
}
\description{
Calculate canopy closure date
}
\details{
Calculates canopy closure dates from LAI and growth rate parameters
}
\examples{
img_dir <- system.file("extdata", "uav_img",package = "cercospoRa")
epidemic_onset_param <-
  read_sb_growth_parameter(img_files = list.files(img_dir,pattern = "tif",
                                                  full.names = TRUE),
                           img_dates = as.POSIXct(
                             c("2022-06-14","2022-06-28"),tz = "UTC"),
                           target_res = 10)
param_rxt <- calc_r_x0(epidemic_onset_param,
                       min_r = 0.02,
                       max_r = 0.05,
                       k = 6)
c_closure <- calc_c_closure(param_rxt,
                            x1 = 1.3,
                            k=6 )
}
