% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_stats.R
\name{cfbd_stats_season_team}
\alias{cfbd_stats_season_team}
\title{\strong{Get season statistics by team}}
\usage{
cfbd_stats_season_team(
  year,
  season_type = "regular",
  team = NULL,
  conference = NULL,
  start_week = NULL,
  end_week = NULL,
  verbose = FALSE
)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format (\emph{YYYY})}

\item{season_type}{(\emph{String} default: regular): Select Season Type - regular, postseason, or both}

\item{team}{(\emph{String} optional): D-I Team}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference\cr
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC\cr
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC\cr}

\item{start_week}{(\emph{Integer} optional): Starting Week - values range from 1-15, 1-14 for seasons pre-playoff, i.e. 2013 or earlier}

\item{end_week}{(\emph{Integer} optional): Ending Week - values range from 1-15, 1-14 for seasons pre-playoff, i.e. 2013 or earlier}

\item{verbose}{Logical parameter (TRUE/FALSE, default: FALSE) to return warnings and messages from function}
}
\value{
\code{\link[=cfbd_stats_season_team]{cfbd_stats_season_team()}} - A data frame with 32 variables:
\describe{
\item{\code{season}: integer}{Season for stats.}
\item{\code{team}: character.}{Team name.}
\item{\code{conference}: character.}{Conference of team.}
\item{\code{games}: integer.}{Number of games.}
\item{\code{time_of_poss_total}: integer.}{Time of possession total.}
\item{\code{pass_comps}: integer.}{Total number of pass completions.}
\item{\code{pass_atts}: integer.}{Total number of pass attempts.}
\item{\code{net_pass_yds}: integer.}{Net passing yards.}
\item{\code{pass_TDs}: integer.}{Passing touchdowns.}
\item{\code{interceptions}: integer.}{Passing interceptions.}
\item{\code{rush_atts}: integer.}{Rushing attempts.}
\item{\code{rush_yds}: integer.}{Rushing yards.}
\item{\code{rush_TDs}: integer.}{Rushing touchdowns.}
\item{\code{total_yds}: integer.}{Rushing total yards.}
\item{\code{fumbles_lost}: integer.}{Fumbles lost.}
\item{\code{turnovers}: integer.}{Turnovers total.}
\item{\code{first_downs}: integer.}{Number of first downs.}
\item{\code{third_downs}: integer.}{Number of third downs.}
\item{\code{third_down_convs}: integer.}{Number of third down conversions.}
\item{\code{fourth_down_convs}: integer.}{Fourth down conversions.}
\item{\code{fourth_downs}: integer.}{Fourth downs.}
\item{\code{penalties}: integer.}{Total number of penalties.}
\item{\code{penalty_yds}: integer.}{Penalty yards total.}
\item{\code{kick_returns}: integer.}{Number of kick returns.}
\item{\code{kick_return_yds}: integer.}{Total kick return yards.}
\item{\code{kick_return_TDs}: integer.}{Total kick return touchdowns.}
\item{\code{punt_returns}: integer.}{Number of punt returns.}
\item{\code{punt_return_yds}: integer.}{Punt return total yards.}
\item{\code{punt_return_TDs}: integer.}{Punt return total touchdowns.}
\item{\code{passes_intercepted}: integer.}{Passes intercepted.}
\item{\code{passes_intercepted_yds}: integer.}{Pass interception return yards.}
\item{\code{passes_intercepted_TDs}: integer.}{Pass interception return touchdowns.}
}
}
\description{
\strong{Get season statistics by team}
}
\examples{
\donttest{
   cfbd_stats_season_team(year = 2018, conference = "B12", start_week = 1, end_week = 8)

   cfbd_stats_season_team(2019, team = "LSU")

   cfbd_stats_season_team(2013, team = "Florida State")
}
}
\keyword{Season}
\keyword{Stats}
\keyword{Team}
