% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretreatment.R
\name{convertToCfd}
\alias{convertToCfd}
\title{Convert data to categorical functional data}
\usage{
convertToCfd(
  x,
  breaks,
  labels = NULL,
  include.lowest = FALSE,
  right = TRUE,
  times = NULL,
  idLabels = NULL,
  nx = 200,
  byrow = FALSE
)
}
\arguments{
\item{x}{matrix or fd object}

\item{breaks}{either a numeric vector of two or more unique cut points or a single number (greater than or equal to 2)
giving the number of intervals into which x is to be cut.}

\item{labels}{labels for the levels of the resulting category. By default, labels are constructed using "(a,b]"
interval notation. If labels = FALSE, simple integer codes are returned instead of a factor.}

\item{include.lowest}{logical, indicating if an ‘x[i]’ equal to the lowest (or highest, for right = FALSE) ‘breaks’ value should be included.}

\item{right}{logical, indicating if the intervals should be closed on the right (and open on the left) or vice versa.}

\item{times}{vector containing values at which \code{fd} is to be evaluated}

\item{idLabels}{vector containing id labels. If NULL it use the names found in the matrix or fd object}

\item{nx}{Only if \code{x} is a fd object. Number of points to evaluate \code{fd}}

\item{byrow}{Only if \code{x} is a matrix. If \code{FALSE}, one column = one trajectory}
}
\value{
a data.frame in the cfda format
}
\description{
Convert data to categorical functional data
}
\examples{
# fd object
data("CanadianWeather")
temp <- CanadianWeather$dailyAv[,, "Temperature.C"]
basis <- create.bspline.basis(c(1, 365), nbasis = 8, norder = 4)
fd <- smooth.basis(1:365, temp, basis)$fd

# "Very Cold" = [-50:-10), "Cold" = [-10:0), ...
out <- convertToCfd(fd, breaks = c(-50, -10, 0, 10, 20, 50),
                    labels = c("Very Cold", "Cold", "Fresh", "OK", "Hot"),
                    times = 1:365)

# matrix
out2 <- convertToCfd(temp, breaks = c(-50, -10, 0, 10, 20, 50),
                     labels = c("Very Cold", "Cold", "Fresh", "OK", "Hot"),
                     times = 1:365, byrow = FALSE)
}
\seealso{
\link{flours}

Other format: 
\code{\link{cut_data}()},
\code{\link{matrixToCfd}()},
\code{\link{remove_duplicated_states}()}
}
\concept{format}
