% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{setdiff_}
\alias{setdiff_}
\alias{intersect_}
\alias{cut_numeric}
\alias{\%in_\%}
\alias{\%!in_\%}
\alias{enframe_}
\alias{deframe_}
\alias{na_rm}
\title{Extra utilities}
\usage{
setdiff_(x, y, dups = TRUE)

intersect_(x, y, dups = TRUE)

cut_numeric(
  x,
  breaks,
  labels = NULL,
  include.lowest = FALSE,
  right = TRUE,
  dig.lab = 3L,
  ordered_result = FALSE,
  ...
)

x \%in_\% table

x \%!in_\% table

enframe_(x, name = "name", value = "value")

deframe_(x)

na_rm(x)
}
\arguments{
\item{x}{A vector or data frame.}

\item{y}{A vector or data frame.}

\item{dups}{Should duplicates be kept? Default is \code{TRUE}.}

\item{breaks}{See \code{?cut}.}

\item{labels}{See \code{?cut}.}

\item{include.lowest}{See \code{?cut}.}

\item{right}{See \code{?cut}.}

\item{dig.lab}{See \code{?cut}.}

\item{ordered_result}{See \code{?cut}.}

\item{...}{See \code{?cut}.}

\item{table}{See \code{?collapse::fmatch}}

\item{name}{The column name to assign the names of a vector.}

\item{value}{The column name to assign the values of a vector.}
}
\value{
\verb{enframe()_} converts a vector to a data frame. \cr
\verb{deframe()_} converts a 1-2 column data frame to a vector. \cr
\code{intersect_()} returns a vector of common values between \code{x} and \code{y}. \cr
\code{setdiff_()} returns a vector of values in \code{x} but not \code{y}. \cr
\code{cut_numeric()} places values of a numeric vector into buckets, defined
through the \code{breaks} argument and returns a factor unless \code{labels = FALSE},
in which case an integer vector of break indices is returned. \cr
\verb{\%in_\%} and \verb{\%!in_\%} both return a logical vector signifying if the values of
\code{x} exist or don't exist in \code{table} respectively. \cr
\code{na_rm()} is a convenience function that removes \code{NA} values and
works only on vectors. For more advanced \code{NA} handling, see \code{?is_na}.
}
\description{
Extra utilities
}
\details{
\code{intersect_()} and \code{setdiff_()} are faster and more efficient
alternatives to \code{intersect()} and \code{setdiff()} respectively. \cr
\code{enframe_()} and \code{deframe_()} are faster alternatives to
\code{tibble::enframe()} and \code{tibble::deframe()} respectively. \cr
\code{cut_numeric()} is a faster and more efficient alternative to
\code{cut.default()}.
}
