% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_dev_rev_deps}
\alias{check_dev_rev_deps}
\title{Run reverse dependency checks against a development version only}
\usage{
check_dev_rev_deps(
  path,
  n = 2L,
  output = tempfile(paste(utils::packageName(), Sys.Date(), sep = "-")),
  lib.loc = .libPaths(),
  repos = getOption("repos"),
  restore = options::opt("restore"),
  reporter = reporter_default(),
  ...
)
}
\arguments{
\item{path}{file path to the package source directory}

\item{n}{\code{integer} value indicating maximum number of subprocesses that can
be simultaneously spawned when executing tasks.}

\item{output}{\code{character} value specifying path where the output should be
stored.}

\item{lib.loc}{\code{character} vector with libraries allowed to be used when
checking packages, defaults to entire \code{\link[=.libPaths]{.libPaths()}}.}

\item{repos}{\code{character} vector of repositories which will be used when
generating task graph and later pulling dependencies.}

\item{restore}{\code{logical} indicating whether output directory should be unlinked before
running checks. If \code{FALSE}, an attempt will me made to restore previous
progress from the same \code{output} (Defaults to \code{NA}, overwritable using option 'checked.restore' or environment variable 'R_CHECKED_RESTORE')}

\item{reporter}{A reporter to provide progress updates. Will default to the
most expressive command-line reporter given your terminal capabilities.}

\item{...}{Additional arguments passed to \code{\link{checked-task-df}} and \code{\link[=run]{run()}}}
}
\value{
\code{\link[=check_design]{check_design()}} R6 class storing all the details
regarding checks that run. Can be combined with
\code{\link{results}} and \code{\link[=summary]{summary()}} methods to generate results.
}
\description{
\code{\link[=check_dev_rev_deps]{check_dev_rev_deps()}} works similarly to \code{\link[=check_rev_deps]{check_rev_deps()}} but it runs
R CMD check only once for each package, with the development version of the
package installed. It is advantageous to check whether adding a new package
into a repository breaks existing packages that possibly take said package
as a \code{Suggests} dependency.
}
\seealso{
Other checks: 
\code{\link{check_design}},
\code{\link{check_dir}()},
\code{\link{check_pkgs}()},
\code{\link{check_rev_deps}()},
\code{\link{new_check_design}()}
}
\concept{checks}
