% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDirectory.r
\name{checkDirectory}
\alias{assertDirectory}
\alias{assert_directory}
\alias{checkDirectory}
\alias{expect_directory}
\alias{testDirectory}
\alias{test_directory}
\title{Check for existence and access rights of directories}
\usage{
checkDirectory(x, access = "")

assertDirectory(x, access = "", add = NULL, .var.name = NULL)

assert_directory(x, access = "", add = NULL, .var.name = NULL)

testDirectory(x, access = "")

test_directory(x, access = "")

expect_directory(x, access = "", info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{access}{[\code{character(1)}]\cr
Single string containing possible characters \sQuote{r}, \sQuote{w} and \sQuote{x} to
force a check for read, write or execute access rights, respectively.
Write and executable rights are not checked on Windows.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[\code{NULL} || \code{character(1)}]\cr
Name of the checked object to print in error message. If \code{NULL},
the name will be heuristically determined via \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertDirectory}/\code{assert_directory}
 throws an error message, \code{testDirectory}/\code{test_directory}
 returns \code{FALSE},
 and \code{checkDirectory} returns a string with the error message.
 The function \code{expect_directory} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check for existence and access rights of directories
}
\examples{
# Is R's home directory readable?
testDirectory(R.home(), "r")

# Is R's home directory readable and writable?
testDirectory(R.home(), "rw")
}
\seealso{
Other filesystem: \code{\link{checkAccess}},
  \code{\link{checkFile}}, \code{\link{checkPathForOutput}}
}

